/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.ArrayList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;

public class IndexedInstructionCollection<T extends Instruction>
extends InstructionCollection<T> {
    private final List<IndexedCollectionSlot> slots = new ArrayList<IndexedCollectionSlot>();

    public IndexedInstructionCollection(Instruction parent) {
        super(parent);
    }

    public void setValues(Iterable<T> values) {
        if (this.head != null) {
            throw new UnsupportedOperationException("Cannot replace insn list.");
        }
        int i = 0;
        for (Instruction value : values) {
            IndexedCollectionSlot slot = new IndexedCollectionSlot(this, this.parent, i++);
            this.add(value, slot);
            this.slots.add(slot);
        }
    }

    public T get(int index) {
        return this.slots.get(index).get();
    }

    @Override
    public void add(T value) {
        throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
    }

    @Override
    public void addAll(Iterable<? extends T> values) {
        throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
    }

    private class IndexedCollectionSlot
    extends InstructionCollection.CollectionSlot {
        private final int index;

        public IndexedCollectionSlot(IndexedInstructionCollection indexedInstructionCollection, Instruction parent, int index) {
            super(indexedInstructionCollection, parent);
            this.index = index;
        }

        @Override
        void remove() {
            this.removeValue();
        }

        @Override
        void insertBefore(Instruction value) {
            throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
        }

        @Override
        void insertAfter(Instruction value) {
            throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
        }
    }
}

