/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.SimpleInstruction;
import net.covers1624.coffeegrinder.type.AType;

public final class PostIncrement
extends SimpleInstruction {
    private final InstructionSlot<Reference> reference = new InstructionSlot(this);
    private final boolean positive;

    public PostIncrement(Reference reference, boolean positive) {
        this.reference.set(reference);
        this.positive = positive;
    }

    @Override
    public AType getResultType() {
        return this.getReference().getType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitPostIncrement(this, ctx);
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (this.isConnected()) {
            this.getReference().setReadFrom(true);
            this.getReference().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.getReference().setReadFrom(true);
        this.getReference().setWrittenTo(true);
    }

    public boolean isPositive() {
        return this.positive;
    }

    public Reference getReference() {
        return this.reference.get();
    }
}

