package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 5/10/21.
 */
public final class ForEachLoop extends AbstractLoop {

    private final InstructionSlot<LocalReference> variable = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> iterator = new InstructionSlot<>(this);
    private final InstructionSlot<BlockContainer> body = new InstructionSlot<>(this);

    public ForEachLoop(LocalReference variable, Instruction iterator, BlockContainer body) {
        this.variable.set(variable);
        this.iterator.set(iterator);
        this.body.set(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = super.computeFlags();
        flags.clear(InstructionFlag.END_POINT_UNREACHABLE);
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitForEachLoop(this, ctx);
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (isConnected()) {
            getVariable().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        getVariable().setWrittenTo(true);
    }

    public LocalReference getVariable() {
        return variable.get();
    }

    public Instruction getIterator() {
        return iterator.get();
    }

    @Override
    public BlockContainer getBody() {
        return body.get();
    }
}
