package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 5/4/21.
 */
public final class IfInstruction extends Instruction {

    private final InstructionSlot<Instruction> condition = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> trueInsn = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> falseInsn = new InstructionSlot<>(this);

    public IfInstruction(Instruction condition, Instruction trueInsn) {
        this(condition, trueInsn, new Nop());
    }

    public IfInstruction(Instruction condition, Instruction trueInsn, Instruction falseInsn) {
        this.condition.set(condition);
        this.trueInsn.set(trueInsn);
        this.falseInsn.set(falseInsn);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = InstructionFlag.NONE.copy();
        flags.or(getDirectFlags());
        flags.or(condition.get().getFlags());
        flags.or(SemanticHelper.combineBranches(getTrueInsn().getFlags(), getFalseInsn().getFlags()));
        return flags;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitIfInstruction(this, ctx);
    }

    //@formatter:off
    public Instruction getCondition() { return condition.get(); }
    public Instruction getTrueInsn() { return trueInsn.get(); }
    public Instruction getFalseInsn() { return falseInsn.get(); }
    public void setCondition(Instruction condition) { this.condition.set(condition); }
    public void setTrueInsn(Instruction trueInsn) { this.trueInsn.set(trueInsn); }
    public void setFalseInsn(Instruction falseInsn) { this.falseInsn.set(falseInsn); }
    //@formatter:on
}
