/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.compilerserver;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.Nullable;

class FastJavacClasspathIndex
implements Closeable {
    private final List<ZipFile> openZips = new ArrayList<ZipFile>();
    private final Map<JavaFileManager.Location, Map<String, List<JavaFileObject>>> index = new HashMap<JavaFileManager.Location, Map<String, List<JavaFileObject>>>();

    FastJavacClasspathIndex() {
    }

    public void addPath(JavaFileManager.Location location, Path path) throws IOException {
        String fName = path.getFileName().toString();
        if (fName.endsWith(".jar") || fName.endsWith(".zip")) {
            this.indexZip(location, path.toFile());
        } else if (!fName.endsWith(".jmod")) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.indexDirectory(location, path);
            } else {
                throw new IllegalArgumentException("Unknown file type, can't index. " + path);
            }
        }
    }

    private void indexZip(JavaFileManager.Location location, File file) throws IOException {
        ZipFile zip = new ZipFile(file);
        this.openZips.add(zip);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            String fPath = entry.getName();
            if (fPath.startsWith("/")) {
                fPath = fPath.substring(1);
            }
            this.addEntry(location, new ZipFileObject(file, zip, entry, fPath));
        }
    }

    private void indexDirectory(JavaFileManager.Location location, Path dir) throws IOException {
        try (Stream<Path> dirStream = Files.walk(dir, new FileVisitOption[0]);){
            for (Path path : dirStream::iterator) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                String fPath = dir.relativize(path).toString().replace('\\', '/');
                this.addEntry(location, new PathObject(path, fPath));
            }
        }
    }

    private void addEntry(JavaFileManager.Location location, JavaFileObject obj) {
        String name = obj.getName();
        int lastSlash = name.lastIndexOf("/");
        String baseName = (lastSlash == -1 ? "" : name.substring(0, lastSlash)) + "/";
        this.index.computeIfAbsent(location, e -> new HashMap()).computeIfAbsent(baseName, e -> new ArrayList()).add(obj);
    }

    public JavaFileManager fileManager(JavaFileManager delegate) {
        return new ForwardingJavaFileManager<JavaFileManager>(delegate){

            @Override
            public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                if (file instanceof AbstractJavaFileObject) {
                    String fName = file.getName();
                    int lastDot = fName.lastIndexOf(46);
                    if (lastDot != -1) {
                        fName = fName.substring(0, lastDot);
                    }
                    return fName.replace('/', '.');
                }
                return super.inferBinaryName(location, file);
            }

            @Override
            public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                Stream<Object> toFilter;
                Map locationIndex = (Map)FastJavacClasspathIndex.this.index.get(location);
                if (locationIndex == null) {
                    return super.list(location, packageName, kinds, recurse);
                }
                String folder = packageName.replace('.', '/') + "/";
                if (!recurse) {
                    List entries = (List)locationIndex.get(folder);
                    if (entries == null) {
                        return Collections.emptyList();
                    }
                    toFilter = entries.stream();
                } else {
                    toFilter = locationIndex.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(folder)).flatMap(e -> ((List)e.getValue()).stream());
                }
                if (!kinds.isEmpty()) {
                    toFilter = toFilter.filter(e -> kinds.contains((Object)e.getKind()));
                }
                return toFilter.collect(Collectors.toList());
            }
        };
    }

    @Override
    public void close() throws IOException {
        for (ZipFile zip : this.openZips) {
            zip.close();
        }
    }

    private static abstract class AbstractJavaFileObject
    implements JavaFileObject {
        protected final String name;
        protected final JavaFileObject.Kind kind;

        public AbstractJavaFileObject(String name) {
            this.name = name;
            this.kind = AbstractJavaFileObject.findKind(name);
        }

        @Override
        public String getCharContent(boolean ignoreEncodingErrors) throws IOException {
            try (InputStream is = this.openInputStream();){
                int len;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                String string = bos.toString("UTF-8");
                return string;
            }
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new StringReader(this.getCharContent(ignoreEncodingErrors));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.getKind().equals((Object)kind) && this.getName().endsWith("/" + simpleName + kind.extension);
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        @Nullable
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        @Nullable
        public Modifier getAccessLevel() {
            return null;
        }

        private static JavaFileObject.Kind findKind(String name) {
            if (name.endsWith(".class")) {
                return JavaFileObject.Kind.CLASS;
            }
            if (name.endsWith(".java")) {
                return JavaFileObject.Kind.SOURCE;
            }
            if (name.endsWith(".html")) {
                return JavaFileObject.Kind.HTML;
            }
            return JavaFileObject.Kind.OTHER;
        }
    }

    public static class ZipFileObject
    extends AbstractJavaFileObject {
        private final File zipFile;
        private final ZipFile archive;
        private final ZipEntry entry;

        public ZipFileObject(File zipFile, ZipFile archive, ZipEntry entry, String fPath) {
            super(fPath);
            this.zipFile = zipFile;
            this.archive = archive;
            this.entry = entry;
        }

        @Override
        public URI toUri() {
            return URI.create("jar:" + this.zipFile.toURI().normalize() + (this.name.startsWith("/") ? "!" : "!/") + this.name);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.archive.getInputStream(this.entry);
        }
    }

    public static class PathObject
    extends AbstractJavaFileObject {
        private final Path file;

        public PathObject(Path file, String fPath) {
            super(fPath);
            this.file = file;
        }

        @Override
        public URI toUri() {
            return this.file.toUri();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
    }
}

