/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractLoop;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class ForLoop
extends AbstractLoop {
    private final InstructionSlot<Instruction> initializer = new InstructionSlot(this);
    private final InstructionSlot<Instruction> condition = new InstructionSlot(this);
    private final InstructionSlot<BlockContainer> body = new InstructionSlot(this);
    private final InstructionSlot<Block> increment = new InstructionSlot(this);

    public ForLoop(Instruction initializer, Instruction condition, BlockContainer body, Instruction increment) {
        this.initializer.set(initializer);
        this.condition.set(condition);
        this.body.set(body);
        this.increment.set(increment);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = super.computeFlags();
        if (LdcMatching.matchLdcBoolean(this.getCondition(), true) == null) {
            flags.clear(InstructionFlag.END_POINT_UNREACHABLE);
        }
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitForLoop(this, ctx);
    }

    public Instruction getInitializer() {
        return this.initializer.get();
    }

    public Instruction getCondition() {
        return this.condition.get();
    }

    public Block getIncrement() {
        return this.increment.get();
    }

    public void setInitializer(Instruction initializer) {
        this.initializer.set(initializer);
    }

    public void setCondition(Instruction condition) {
        this.condition.set(condition);
    }

    public void setIncrement(Block increment) {
        this.increment.set(increment);
    }

    @Override
    public BlockContainer getBody() {
        return this.body.get();
    }
}

