/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public abstract class AnnotationParser
extends AnnotationVisitor {
    private final TypeResolver resolver;

    public AnnotationParser(TypeResolver resolver) {
        super(589824);
        this.resolver = resolver;
    }

    public static void parseNodes(TypeResolver resolver, TypeAnnotationData typeAnnotationConflicts, @Nullable Iterable<AnnotationNode> nodes, Consumer<AnnotationData> cons) {
        if (nodes == null) {
            return;
        }
        for (AnnotationNode node : nodes) {
            node.accept((AnnotationVisitor)AnnotationParser.newVisitor(resolver, node.desc, e -> {
                if (!typeAnnotationConflicts.annotations.contains(e)) {
                    cons.accept((AnnotationData)e);
                }
            }));
        }
    }

    public static AnnotationParser newVisitor(TypeResolver resolver, String desc, final Consumer<AnnotationData> cons) {
        final ClassType type = resolver.resolveClass(Type.getType((String)desc));
        final ImmutableMap.Builder values = ImmutableMap.builder();
        return new AnnotationParser(resolver){

            @Override
            public void visitValue(@Nullable String name, Object value) {
                assert (name != null);
                values.put((Object)name, value);
            }

            public void visitEnd() {
                cons.accept(new AnnotationData(type, (Map<String, Object>)values.build()));
            }
        };
    }

    public static Object processAnnotationDefault(TypeResolver resolver, Object obj) {
        final AtomicReference valueRef = new AtomicReference();
        AnnotationParser visitor = new AnnotationParser(resolver){

            @Override
            public void visitValue(@Nullable String name, Object value) {
                assert (name == null);
                valueRef.set(value);
            }
        };
        AnnotationParser.accept(visitor, obj);
        visitor.visitEnd();
        assert (valueRef.get() != null);
        return valueRef.get();
    }

    public abstract void visitValue(@Nullable String var1, Object var2);

    public void visit(@Nullable String name, Object value) {
        this.visitValue(name, AnnotationParser.processValue(this.resolver, value));
    }

    public void visitEnum(String name, String descriptor, String value) {
        ClassType type = this.resolver.resolveClass(Type.getType((String)descriptor));
        Field field = (Field)FastStream.of(type.getFields()).filter(f -> f.getName().equals(value)).only();
        this.visitValue(name, field);
    }

    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        return AnnotationParser.newVisitor(this.resolver, descriptor, data -> this.visitValue(name, data));
    }

    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationParser(this.resolver){
            private final ImmutableList.Builder<Object> values;
            {
                super(resolver);
                this.values = ImmutableList.builder();
            }

            @Override
            public void visitValue(@Nullable String name2, Object value) {
                assert (name2 == null);
                this.values.add(value);
            }

            public void visitEnd() {
                AnnotationParser.this.visitValue(name, this.values.build());
            }
        };
    }

    private static Object processValue(TypeResolver resolver, Object value) {
        if (value instanceof Type) {
            AType result = resolver.resolveTypeDecl((Type)value);
            assert (result instanceof ArrayType || result instanceof ClassType);
            return result;
        }
        assert (!value.getClass().isArray());
        return value;
    }

    private static void accept(AnnotationVisitor visitor, Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String[].class, AnnotationNode.class, List.class}, (Object)object2, n)) {
            case 0: {
                String[] typeValue = (String[])object2;
                visitor.visitEnum(null, typeValue[0], typeValue[1]);
                break;
            }
            case 1: {
                AnnotationNode annotationValue = (AnnotationNode)object2;
                annotationValue.accept(visitor.visitAnnotation(null, annotationValue.desc));
                break;
            }
            case 2: {
                List arrayValue = (List)object2;
                AnnotationVisitor arrayAnnotationVisitor = visitor.visitArray(null);
                if (arrayAnnotationVisitor == null) break;
                for (Object o : arrayValue) {
                    AnnotationParser.accept(arrayAnnotationVisitor, o);
                }
                arrayAnnotationVisitor.visitEnd();
                break;
            }
            default: {
                visitor.visit(null, value);
            }
        }
    }
}

