package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 28/5/21.
 */
public final class TryCatch extends TryInstruction {

    private final InstructionSlot<BlockContainer> tryBody = new InstructionSlot<>(this);
    public final InstructionCollection<TryCatchHandler> handlers = new InstructionCollection<>(this);

    public TryCatch(BlockContainer tryBody) {
        setTryBody(tryBody);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = getTryBody().getFlags().copy();
        for (TryCatchHandler handler : handlers) {
            flags = SemanticHelper.combineBranches(flags, handler.getFlags());
        }

        return flags;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTryCatch(this, ctx);
    }

    //@formatter:off
    @Override public BlockContainer getTryBody() { return tryBody.get(); }
    @Override public void setTryBody(BlockContainer tryBody) { this.tryBody.set(tryBody); }
    //@formatter:on

    public static final class TryCatchHandler extends Instruction {

        private final InstructionSlot<LocalReference> variable = new InstructionSlot<>(this);
        private final InstructionSlot<BlockContainer> body = new InstructionSlot<>(this);

        public boolean isUnprocessedFinally = false;

        public TryCatchHandler(BlockContainer body, LocalReference variable) {
            this.variable.set(variable);
            this.body.set(body);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitTryCatchHandler(this, ctx);
        }

        @Override
        protected void onChildModified() {
            super.onChildModified();
            if (isConnected()) {
                getVariable().setWrittenTo(true);
            }
        }

        @Override
        protected void onConnected() {
            super.onConnected();
            getVariable().setWrittenTo(true);
        }

        //@formatter:off
        public LocalReference getVariable() { return variable.get(); }
        public BlockContainer getBody() { return body.get(); }
        public void setVariable(Store variable) { this.variable.set(variable); }
        public TryCatch getTry() { return ((TryCatch) getParent()); }
        //@formatter:on
    }
}
