package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import org.objectweb.asm.Type;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

import static net.covers1624.quack.collection.FastStream.of;

/**
 * Created by covers1624 on 29/4/22.
 */
public class RawClass extends ClassType {

    private final ClassType decl;

    private final Supplier<ClassType> superClass;
    private final Supplier<List<ClassType>> interfaces;
    private final Supplier<List<Field>> fields;
    private final Supplier<List<Method>> methods;

    public RawClass(ClassType decl) {
        this.decl = decl;
        superClass = Util.singleMemoize(() -> decl.getSuperClass().asRaw());
        interfaces = Util.singleMemoize(() -> of(decl.getInterfaces()).map(ClassType::asRaw).toImmutableList());
        fields = Util.singleMemoize(() -> of(decl.getFields()).map(Field::asRaw).toImmutableList());
        methods = Util.singleMemoize(() -> of(decl.getMethods()).map(Method::asRaw).toImmutableList());
    }

    //@formatter:off
    @Override public List<ClassType> getNestedClasses() { throw new UnsupportedOperationException(); }
    @Override public List<Field> getFields() { return fields.get(); }
    @Override public List<Method> getMethods() { return methods.get(); }
    @Override public DeclType getDeclType() { return decl.getDeclType(); }
    @Override public String getPackage() { return decl.getPackage(); }
    @Override public EnumBitSet<AccessFlag> getAccessFlags() { return decl.getAccessFlags(); }
    @Override public Optional<ClassType> getEnclosingClass() { return decl.getEnclosingClass().map(ClassType::asRaw); }
    @Override public Optional<Method> getEnclosingMethod() { throw new UnsupportedOperationException(); }
    @Override public Type getDescriptor() { return decl.getDescriptor(); }
    @Override public ClassType getDeclaration() { return decl; }
    @Override public ClassType asRaw() { return this; }
    @Override public ClassType getSuperClass() { return superClass.get(); }
    @Override public List<ClassType> getInterfaces() { return interfaces.get(); }
    @Override public String getName() { return decl.getName(); }
    @Override public List<TypeParameter> getTypeParameters() { return List.of(); }
    @Override public String getFullName() { return decl.getFullName(); }
    //@formatter:on
}
