/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class MethodReference
extends Instruction {
    private ClassType resultType;
    private final ClassType targetClassType;
    private Method method;
    public boolean explicitTypeArgs;
    private final InstructionSlot<Instruction> target = new InstructionSlot(this);

    public MethodReference(ClassType resultType, Method method, Instruction target) {
        this(resultType, method.getDeclaringClass(), method, target);
    }

    public MethodReference(ClassType resultType, ClassType targetClassType, Method method, Instruction target) {
        this.resultType = resultType;
        this.targetClassType = targetClassType;
        this.method = method;
        this.target.set(target);
    }

    @Override
    public ClassType getResultType() {
        return this.resultType;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitMethodReference(this, ctx);
    }

    public Instruction getTarget() {
        return this.target.get();
    }

    public ClassType getTargetClassType() {
        return this.targetClassType;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setResultType(ClassType resultType) {
        this.resultType = resultType;
    }
}

