/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.asm.AsmClass;
import net.covers1624.coffeegrinder.type.asm.ReferenceTypeSignatureParser;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class TypeResolver {
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type CLASS_TYPE = Type.getType(Class.class);
    public static final Type ENUM_TYPE = Type.getType(Enum.class);
    public static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    public static final Type SERIALIZABLE_TYPE = Type.getType(Serializable.class);
    public static final Type CLONEABLE_TYPE = Type.getType(Cloneable.class);
    private final ClassResolver classResolver;
    private final Map<Type, AType> typeCache = Collections.synchronizedMap(new HashMap());

    public TypeResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public void reset() {
        this.typeCache.clear();
        this.classResolver.reset();
    }

    public AType resolveGenericType(ITypeParameterizedMember scope, String signature) {
        return ReferenceTypeSignatureParser.parse(this, scope, signature);
    }

    public AType resolveType(Type type) {
        AType ret = this.resolveTypeDecl(type);
        if (!(ret instanceof ClassType)) {
            return ret;
        }
        ClassType iClass = (ClassType)ret;
        if (TypeSystem.isGeneric(iClass)) {
            return iClass.asRaw();
        }
        return iClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AType resolveTypeDecl(Type type) {
        AType ret = this.typeCache.get(type);
        if (ret != null) {
            return ret;
        }
        Map<Type, AType> map = this.typeCache;
        synchronized (map) {
            ret = this.typeCache.get(type);
            if (ret != null) {
                return ret;
            }
            ret = this.computeType(type);
            AType prev = this.typeCache.put(type, ret);
            assert (prev == null);
            return ret;
        }
    }

    private AType computeType(Type type) {
        return switch (type.getSort()) {
            case 0 -> PrimitiveType.VOID;
            case 1 -> PrimitiveType.BOOLEAN;
            case 2 -> PrimitiveType.CHAR;
            case 3 -> PrimitiveType.BYTE;
            case 4 -> PrimitiveType.SHORT;
            case 5 -> PrimitiveType.INT;
            case 6 -> PrimitiveType.FLOAT;
            case 7 -> PrimitiveType.LONG;
            case 8 -> PrimitiveType.DOUBLE;
            case 9 -> this.makeArray(this.resolveType(Type.getType((String)type.getDescriptor().substring(1))));
            case 10 -> new AsmClass(this, this.classResolver.getClassNode(type.getInternalName()));
            default -> throw new IllegalStateException("Unhandled type. Sort: " + type.getSort());
        };
    }

    public ReferenceType resolveReferenceType(Type type) {
        assert (type.getSort() == 10 || type.getSort() == 9);
        return (ReferenceType)this.resolveType(type);
    }

    public ClassType resolveClass(Class<?> clazz) {
        return this.resolveClass(Type.getType(clazz));
    }

    public ClassType resolveClass(String name) {
        return this.resolveClass(Type.getObjectType((String)name.replace('.', '/')));
    }

    public ClassType resolveClass(Type desc) {
        assert (desc.getSort() == 10);
        return (ClassType)this.resolveType(desc);
    }

    public ClassType resolveClassDecl(String name) {
        return this.resolveClassDecl(Type.getObjectType((String)name.replace('.', '/')));
    }

    @Nullable
    public ClassType tryResolveClassDecl(String name) {
        try {
            return this.resolveClassDecl(name);
        }
        catch (ClassResolver.ClassNotFoundException ex) {
            return null;
        }
    }

    public ClassType resolveClassDecl(Type desc) {
        assert (desc.getSort() == 10);
        return (ClassType)this.resolveTypeDecl(desc);
    }

    public ArrayType makeArray(AType elementType) {
        return new ArrayType(this, elementType);
    }

    public boolean classExists(String name) {
        return this.classResolver.classExists(name);
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }
}

