package net.covers1624.coffeegrinder.bytecode;

import net.covers1624.coffeegrinder.util.None;

/**
 * Created by covers1624 on 8/9/21.
 */
public abstract class SimpleInsnVisitor<C> extends InsnVisitor<None, C> {

    protected static final None NONE = None.INSTANCE;

    @Override
    public None visitDefault(Instruction insn, C ctx) {
        Instruction child = insn.getFirstChildOrNull();
        while (child != null) {
            Instruction next = child.getNextSiblingOrNull();
            child.accept(this, ctx);
            child = next;
        }
        return NONE;
    }
}
