/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.covers1624.coffeegrinder.util.resolver.AbstractPathResolver;
import net.covers1624.quack.io.IOUtils;

public class JarResolver
extends AbstractPathResolver {
    protected final FileSystem fs;
    private final Path rootFolder;

    public JarResolver(Path path) {
        this(path, "/");
    }

    public JarResolver(Path path, String rootPath) {
        super(path);
        try {
            this.fs = IOUtils.getJarFileSystem((Path)path, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create FileSystem.", e);
        }
        this.rootFolder = this.fs.getPath(rootPath, new String[0]);
    }

    @Override
    protected void validate() {
        if (Files.notExists(this.path, new LinkOption[0])) {
            throw new IllegalStateException("File does not exist.");
        }
        if (!Files.isRegularFile(this.path, new LinkOption[0])) {
            throw new IllegalStateException("Not a file.");
        }
        String fName = this.path.getFileName().toString();
        if (!fName.endsWith(".jar") && !fName.endsWith(".zip")) {
            throw new IllegalStateException("Expected zip or jar file extension.");
        }
    }

    @Override
    protected Path getRootPath() {
        return this.rootFolder;
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    public String toString() {
        return "JarResolver(" + String.valueOf(this.path) + ")";
    }
}

