/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Comparison
extends Instruction {
    private ComparisonKind kind;
    private final InstructionSlot<Instruction> left = new InstructionSlot(this);
    private final InstructionSlot<Instruction> right = new InstructionSlot(this);

    public Comparison(ComparisonKind kind, Instruction left, Instruction right) {
        this.kind = kind;
        this.left.set(left);
        this.right.set(right);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitComparison(this, ctx);
    }

    public ComparisonKind getKind() {
        return this.kind;
    }

    public Instruction getLeft() {
        return this.left.get();
    }

    public Instruction getRight() {
        return this.right.get();
    }

    public void setKind(ComparisonKind kind) {
        this.kind = kind;
    }

    public void setLeft(Instruction left) {
        this.left.set(left);
    }

    public void setRight(Instruction right) {
        this.right.set(right);
    }

    public static enum ComparisonKind {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THAN(">"),
        GREATER_THAN_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_EQUAL("<=");

        public final String chars;

        private ComparisonKind(String chars) {
            this.chars = chars;
        }

        public ComparisonKind negate() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NOT_EQUAL;
                case 1 -> EQUAL;
                case 2 -> LESS_THAN_EQUAL;
                case 3 -> LESS_THAN;
                case 4 -> GREATER_THAN_EQUAL;
                case 5 -> GREATER_THAN;
            };
        }
    }
}

