/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.cli;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.util.ConsumingOutputStream;
import io.codechicken.diffpatch.util.IOValidationException;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.covers1624.quack.io.NullOutputStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class BakePatchesOperation
extends CliOperation<BakeSummary> {
    final boolean summary;
    final Input patchesInput;
    final Output bakedOutput;
    final String patchesPrefix;
    final String lineEnding;

    private BakePatchesOperation(PrintStream logger, LogLevel level, Consumer<PrintStream> helpCallback, boolean summary, Input patchesInput, Output bakedOutput, String patchesPrefix, String lineEnding) {
        super(logger, level, helpCallback);
        this.summary = summary;
        this.patchesInput = patchesInput;
        this.bakedOutput = bakedOutput;
        this.patchesPrefix = patchesPrefix;
        this.lineEnding = lineEnding;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CliOperation.Result<BakeSummary> operate() throws IOException {
        try {
            this.patchesInput.validate("bake input");
        }
        catch (IOValidationException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        if (this.patchesInput instanceof Input.SingleInput) {
            Input.SingleInput input = (Input.SingleInput)this.patchesInput;
            if (!(this.bakedOutput instanceof Output.SingleOutput)) {
                this.log(LogLevel.ERROR, "Can't specify baked output directory or archive when baking a single file.", new Object[0]);
                this.printHelp();
                return new CliOperation.Result<BakeSummary>(-1);
            }
            Output.SingleOutput output = (Output.SingleOutput)this.bakedOutput;
            try (OutputStream os = output.open();){
                os.write(BakePatchesOperation.bakePatch(input.name(), input.readLines(), this.lineEnding).getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            return new CliOperation.Result<BakeSummary>(0, new BakeSummary());
        }
        if (!(this.patchesInput instanceof Input.MultiInput)) {
            this.log(LogLevel.ERROR, "Can't patch between single files and folders/archives.", new Object[0]);
            this.printHelp();
            return new CliOperation.Result<BakeSummary>(-1);
        }
        try (Input.MultiInput in = (Input.MultiInput)this.patchesInput;
             Output.MultiOutput out = (Output.MultiOutput)this.bakedOutput;){
            in.open(this.patchesPrefix);
            out.open(true);
            for (String file : in.index()) {
                out.write(file, BakePatchesOperation.bakePatch(file, in.readLines(file), this.lineEnding).getBytes(StandardCharsets.UTF_8));
            }
        }
        return new CliOperation.Result<BakeSummary>(0, new BakeSummary());
    }

    private static String bakePatch(String fileName, List<String> lines, String lineEnding) {
        PatchFile patch = PatchFile.fromLines(fileName, lines, true);
        String baked = String.join((CharSequence)lineEnding, patch.toLines(false));
        return baked + lineEnding;
    }

    public static class Builder {
        private static final PrintStream NULL_STREAM = new PrintStream((OutputStream)NullOutputStream.INSTANCE);
        private PrintStream logger = NULL_STREAM;
        private Consumer<PrintStream> helpCallback = SneakyUtils.nullCons();
        private LogLevel level = LogLevel.WARN;
        private boolean summary;
        @Nullable
        private Input patchesInput;
        @Nullable
        private Output bakedOutput;
        private String patchesPrefix = "";
        private String lineEnding = System.lineSeparator();

        private Builder() {
        }

        public Builder logTo(Consumer<String> func) {
            return this.logTo(new ConsumingOutputStream(func));
        }

        public Builder logTo(PrintStream logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Builder logTo(OutputStream logger) {
            return this.logTo(new PrintStream(logger));
        }

        public Builder helpCallback(Consumer<PrintStream> helpCallback) {
            this.helpCallback = Objects.requireNonNull(helpCallback);
            return this;
        }

        public Builder level(LogLevel level) {
            this.level = level;
            return this;
        }

        public Builder summary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder patchesInput(Input patchesInput) {
            this.patchesInput = Objects.requireNonNull(patchesInput);
            return this;
        }

        public Builder bakedOutput(Output bakedOutput) {
            this.bakedOutput = Objects.requireNonNull(bakedOutput);
            return this;
        }

        public Builder patchesPrefix(String patchesPrefix) {
            this.patchesPrefix = Objects.requireNonNull(patchesPrefix);
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public BakePatchesOperation build() {
            if (this.patchesInput == null) {
                throw new IllegalStateException("patchesInput is required.");
            }
            if (this.bakedOutput == null) {
                throw new IllegalStateException("bakedOutput is required.");
            }
            return new BakePatchesOperation(this.logger, this.level, this.helpCallback, this.summary, this.patchesInput, this.bakedOutput, this.patchesPrefix, this.lineEnding);
        }
    }

    public static class BakeSummary {
    }
}

