/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

public final class LdcNumber
extends LdcInsn {
    private final Number value;
    private final AType resultType;

    public LdcNumber(Number value) {
        this.value = value;
        Number number = value;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        this.resultType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Float.class, Integer.class, Long.class}, (Object)number2, n)) {
            case 0 -> {
                Double v = (Double)number2;
                yield PrimitiveType.DOUBLE;
            }
            case 1 -> {
                Float v = (Float)number2;
                yield PrimitiveType.FLOAT;
            }
            case 2 -> {
                Integer i = (Integer)number2;
                yield new IntegerConstantType(i);
            }
            case 3 -> {
                Long l = (Long)number2;
                yield PrimitiveType.LONG;
            }
            default -> throw new IllegalArgumentException("Unknown LdcNumber value: " + String.valueOf(value.getClass()));
        };
    }

    @Override
    public AType getResultType() {
        return this.resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcNumber(this, ctx);
    }

    @Override
    public Instruction copy() {
        return new LdcNumber(this.value);
    }

    @Override
    public Number getRawValue() {
        return this.value;
    }

    public Number getValue() {
        return this.value;
    }

    public int intValue() {
        assert (this.value instanceof Integer);
        return this.value.intValue();
    }
}

