/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Invoke
extends AbstractInvoke {
    private final InvokeKind kind;
    private final ClassType targetClassType;
    private Method method;
    private AType resultType;
    private final InstructionSlot<Instruction> target = new InstructionSlot(this);
    private final IndexedInstructionCollection<Instruction> arguments = new IndexedInstructionCollection(this);

    public Invoke(InvokeKind kind, Method method, Instruction target, Iterable<Instruction> args) {
        this(kind, method.getDeclaringClass(), method, target, args);
    }

    public Invoke(InvokeKind kind, ClassType targetClassType, Method method, Instruction target, Iterable<Instruction> args) {
        this.kind = kind;
        this.targetClassType = targetClassType;
        this.setMethod(method);
        this.setTarget(target);
        this.arguments.setValues(args);
    }

    @Override
    public AType getResultType() {
        return this.resultType;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitInvoke(this, ctx);
    }

    public InvokeKind getKind() {
        return this.kind;
    }

    public ClassType getTargetClassType() {
        return this.targetClassType;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public Instruction getTarget() {
        return this.target.get();
    }

    @Override
    public IndexedInstructionCollection<Instruction> getArguments() {
        return this.arguments;
    }

    public void setTarget(Instruction target) {
        this.target.set(target);
    }

    public void setMethod(Method method) {
        this.method = method;
        this.setResultType(TypeSystem.capture(method.getReturnType()));
    }

    public void setResultType(AType resultType) {
        this.resultType = resultType;
    }

    public static enum InvokeKind {
        VIRTUAL,
        SPECIAL,
        STATIC,
        INTERFACE;

    }
}

