package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 5/5/21.
 */
public final class SwitchTable extends Instruction {

    private final InstructionSlot<Instruction> value = new InstructionSlot<>(this);
    public final InstructionCollection<SwitchSection> sections = new InstructionCollection<>(this);

    public SwitchTable(Instruction value) {
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = getDirectFlags().copy();

        for (SwitchSection section : sections) {
            flags.or(section.getFlags());
        }

        flags.or(value.get().getFlags());
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitSwitchTable(this, ctx);
    }

    //@formatter:off
    public Instruction getValue() { return value.get(); }
    public void setValue(Instruction value) { this.value.set(value); }
    //@formatter:on

    public boolean isExhaustive() {
        return sections.anyMatch(section -> section.values.anyMatch(e -> e instanceof Nop));
    }

    public static final class SwitchSection extends Instruction {

        public final InstructionCollection<Instruction> values = new InstructionCollection<>(this);

        private final InstructionSlot<Instruction> body = new InstructionSlot<>(this);

        public SwitchSection(Instruction body) {
            this.body.set(body);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitSwitchSection(this, ctx);
        }

        //@formatter:off
        public Instruction getBody() { return body.get(); }
        public void setBody(Instruction body) { this.body.set(body); }
        //@formatter:on
    }
}
