package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.accessors.SyntheticAccessor;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

import java.util.List;

/**
 * Created by covers1624 on 13/4/21.
 */
public abstract class Method implements ITypeParameterizedMember {

    public abstract ClassType getDeclaringClass();

    public abstract String getName();

    public abstract AType getReturnType();

    public abstract List<Parameter> getParameters();

    public abstract List<ReferenceType> getExceptions();

    public abstract EnumBitSet<AccessFlag> getAccessFlags();

    public abstract Type getDescriptor();

    public AnnotationSupplier getAnnotationSupplier() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public abstract Object getDefaultAnnotationValue();

    public abstract Method getDeclaration();

    public abstract Method asRaw();

    public abstract boolean isConstructor();

    public final boolean isStatic() {
        return getAccessFlags().get(AccessFlag.STATIC);
    }

    public final boolean isAbstract() {
        return getAccessFlags().get(AccessFlag.ABSTRACT);
    }

    public final boolean isSynthetic() {
        return getAccessFlags().get(AccessFlag.SYNTHETIC);
    }

    public final boolean isBridge() {
        return getAccessFlags().get(AccessFlag.BRIDGE);
    }

    @Nullable
    public SyntheticAccessor getAccessor() {
        throw new UnsupportedOperationException("Accessor method lookup only available from Method declarations.s");
    }

    @Nullable
    @Override
    public TypeParameter resolveTypeParameter(String identifier) {
        for (TypeParameter param : getTypeParameters()) {
            if (param.getName().equals(identifier)) {
                return param;
            }
        }

        return getDeclaringClass().resolveTypeParameter(identifier);
    }

    public String getFullName() {
        return getDeclaringClass().getFullName() + "." + getName();
    }

    @Override
    public String toString() {
        String argTypes = FastStream.of(getParameters()).map(e -> e.getType().getFullName()).join(", ");
        return getFullName() + "(" + argTypes + ")";
    }
}
