package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Created by covers1624 on 15/4/21.
 */
public class Parameter {

    private final int formalIdx;
    private final String name;
    private final Method owner;
    private final AType type;
    private final AType rawType;
    private final EnumBitSet<AccessFlag> flags;
    private final @Nullable AnnotationSupplier annotationSupplier;

    public Parameter(String name, Method owner, AType type, EnumBitSet<AccessFlag> flags) {
        this(name, owner, type, type, flags);
    }

    public Parameter(String name, Method owner, AType type, AType rawType, EnumBitSet<AccessFlag> flags) {
        // Formal idx and annotations don't exist for non-decl parameters.
        this(-1, name, owner, type, rawType, flags, null);
    }

    public Parameter(int formalIdx, String name, Method owner, AType type, AType rawType, EnumBitSet<AccessFlag> flags, @Nullable AnnotationSupplier annotationSupplier) {
        this.formalIdx = formalIdx;
        this.name = name;
        this.owner = owner;
        this.type = type;
        this.rawType = rawType;
        this.flags = flags;
        this.annotationSupplier = annotationSupplier;
    }

    // @formatter:off
    public int getFormalIdx() { return formalIdx; }
    public String getName() { return name; }
    public Method getOwner() { return owner; }
    public AType getType() { return type; }
    public AType getRawType() { return rawType; }
    public EnumBitSet<AccessFlag> getFlags() { return flags; }
    public AnnotationSupplier getAnnotationSupplier() { return requireNonNull(annotationSupplier); }
    // @formatter:on

    public boolean isFinal() {
        return getFlags().get(AccessFlag.FINAL);
    }

    public boolean isMandated() {
        return getFlags().get(AccessFlag.MANDATED);
    }

    public boolean isSynthetic() {
        return getFlags().get(AccessFlag.SYNTHETIC);
    }
}
