package net.covers1624.coffeegrinder.type.asm;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.TypeResolver;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

import java.util.List;

import static java.util.Objects.requireNonNull;

/**
 * Created by covers1624 on 22/12/21.
 */
public class ClassSignatureParser extends SignatureParser {

    @Nullable
    private ClassType superClass;
    private final ImmutableList.Builder<ClassType> interfaces = ImmutableList.builder();

    private ClassSignatureParser(TypeResolver typeResolver, ITypeParameterizedMember scope) {
        super(typeResolver, scope);
    }

    public static ClassSignatureParser parse(TypeResolver typeResolver, ITypeParameterizedMember scope, String signature) {
        ClassSignatureParser visitor = new ClassSignatureParser(typeResolver, scope);
        new SignatureReader(signature).accept(visitor);
        return visitor;
    }

    public ClassType getSuperClass() {
        return requireNonNull(superClass);
    }

    public List<ClassType> getInterfaces() {
        return interfaces.build();
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        return new ReferenceTypeSignatureParser(typeResolver, scope) {
            @Override
            public void endType(AType type) {
                superClass = (ClassType) type;
            }
        };
    }

    @Override
    public SignatureVisitor visitInterface() {
        return new ReferenceTypeSignatureParser(typeResolver, scope) {
            @Override
            public void endType(AType type) {
                interfaces.add((ClassType) type);
            }
        };
    }
}
