/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.target;

import java.io.IOException;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.testcase.TestProcessingException;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TestCaseDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.javasauce.compilerserver.Compiler;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.engine.UniqueId;

public class CompileTargetStepDescriptor
extends TargetStepDescriptor {
    public CompileTargetStepDescriptor(UniqueId prentId) {
        super(prentId, Target.COMPILE);
    }

    @Override
    public void execute(TestCaseDescriptor testDescriptor) throws Throwable {
        String source = testDescriptor.getDecompSource();
        Compiler.CompileResult result = (Compiler.CompileResult)this.process(() -> testDescriptor.root.compiler.compile(testDescriptor.outputSource.path.toUri(), source, testDescriptor.root.javacArgs));
        if (result.javacCrash != null) {
            throw new TestProcessingException(result.javacCrash);
        }
        if (result.success) {
            testDescriptor.setCompileOutput(result.output);
        } else {
            Object fullPath = testDescriptor.outputSource.path.toString().replaceAll("\\\\", "/");
            if (!((String)fullPath).startsWith("/")) {
                fullPath = "/" + (String)fullPath;
            }
            String relPath = "/" + testDescriptor.outputSource.relativePath().replaceAll("\\\\", "/");
            String uniqueLog = result.compileLog.replace((CharSequence)fullPath, relPath);
            this.unabortable(() -> this.assertCompileLogOutput(testDescriptor.outputCompileError, uniqueLog, testDescriptor));
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.fail((String)("Javac failed.\n" + result.compileLog))});
        }
    }

    private void assertCompileLogOutput(@Nullable OutputPath.Entry output, String result, TestCaseDescriptor testDescriptor) throws IOException {
        if (output == null) {
            return;
        }
        String prev = output.readOrNull();
        if (testDescriptor.root.updateOutput) {
            if (prev == null || !prev.equals(result)) {
                output.write(result);
            }
            return;
        }
        if (prev == null) {
            Assertions.assertFalse((boolean)testDescriptor.outputMandatory, (String)"Expected prior compile error output to exist. Re-run in update mode.");
            return;
        }
        Assertions.assertEquals((Object)prev, (Object)result, (String)"Compile log changed.");
    }
}

