package net.covers1624.coffeegrinder.bytecode.insns;

/**
 * Created by covers1624 on 9/9/21.
 */
public enum BinaryOp {
    ADD("+"),
    SUB("-"),
    MUL("*"),
    DIV("/"),
    REM("%"),
    AND("&"),
    OR("|"),
    XOR("^"),
    SHIFT_LEFT("<<"),
    SHIFT_RIGHT(">>"),
    LOGICAL_SHIFT_RIGHT(">>>");
    public final String chars;

    BinaryOp(String chars) {
        this.chars = chars;
    }

    public boolean isLogic() {
        return this == AND || this == OR || this == XOR;
    }
}
