package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 10/6/22.
 */
public final class MethodReference extends Instruction {

    private ClassType resultType;
    private final ClassType targetClassType;
    private Method method;
    public boolean explicitTypeArgs;

    private final InstructionSlot<Instruction> target = new InstructionSlot<>(this);

    public MethodReference(ClassType resultType, Method method, Instruction target) {
        this(resultType, method.getDeclaringClass(), method, target);
    }

    public MethodReference(ClassType resultType, ClassType targetClassType, Method method, Instruction target) {
        this.resultType = resultType;
        this.targetClassType = targetClassType;
        this.method = method;

        this.target.set(target);
    }

    @Override
    public ClassType getResultType() {
        return resultType;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitMethodReference(this, ctx);
    }

    // @formatter:off
    public Instruction getTarget() { return target.get(); }
    public ClassType getTargetClassType() { return targetClassType; }
    public Method getMethod() { return method; }
    public void setMethod(Method method) { this.method = method; }
    public void setResultType(ClassType resultType) { this.resultType = resultType; }
    // @formatter:on
}
