/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.compilerserver;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.javasauce.compilerserver.Compiler;
import net.javasauce.compilerserver.FastJavacClasspathIndex;
import org.jetbrains.annotations.Nullable;

class LocalCompiler
implements Compiler {
    private final FastJavacClasspathIndex index = new FastJavacClasspathIndex();
    private final JavaCompiler compiler;

    public LocalCompiler(Collection<Path> compileClasspath) throws IOException {
        for (Path path : compileClasspath) {
            this.index.addPath(StandardLocation.CLASS_PATH, path);
        }
        String bootClasspath = System.getProperty("sun.boot.class.path");
        if (bootClasspath != null) {
            List paths = Stream.of(bootClasspath.split(File.pathSeparator)).distinct().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path path : paths) {
                this.index.addPath(StandardLocation.PLATFORM_CLASS_PATH, path);
            }
        }
        this.compiler = ToolProvider.getSystemJavaCompiler();
    }

    @Override
    public Compiler.CompileResult compile(URI sourceUri, String source, List<String> extraJavacArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-g");
        args.add("-proc:none");
        args.add("-XDuseUnsharedTable=true");
        args.addAll(extraJavacArgs);
        HashMap<String, byte[]> outputs = new HashMap<String, byte[]>();
        StringWriter logWriter = new StringWriter();
        boolean result = false;
        Throwable javacCrash = null;
        try {
            JavaCompiler.CompilationTask task = this.compiler.getTask(logWriter, this.getFileManager(this.compiler, outputs), null, args, null, Collections.singleton(new StringSource(sourceUri, source)));
            result = task.call();
        }
        catch (Throwable ex) {
            javacCrash = ex;
        }
        return new Compiler.CompileResult(outputs, result, logWriter.toString(), javacCrash);
    }

    @Override
    public void close() throws IOException {
        this.index.close();
    }

    private JavaFileManager getFileManager(JavaCompiler compiler, final Map<String, byte[]> outputs) {
        return new ForwardingJavaFileManager<JavaFileManager>(this.index.fileManager(compiler.getStandardFileManager(null, null, null))){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String cName, JavaFileObject.Kind kind, FileObject sibling) {
                return new SimpleJavaFileObject(URI.create("output:///" + cName + ".class"), kind){

                    @Override
                    public OutputStream openOutputStream() {
                        return new ByteArrayOutputStream(){

                            @Override
                            public void close() {
                                outputs.put(cName.replace('.', '/') + ".class", this.toByteArray());
                            }
                        };
                    }
                };
            }

            @Override
            public boolean hasLocation(JavaFileManager.Location location) {
                if (location == StandardLocation.ANNOTATION_PROCESSOR_PATH) {
                    return true;
                }
                return super.hasLocation(location);
            }

            @Override
            @Nullable
            public ClassLoader getClassLoader(JavaFileManager.Location location) {
                if (location == StandardLocation.ANNOTATION_PROCESSOR_PATH) {
                    return null;
                }
                return super.getClassLoader(location);
            }
        };
    }

    private static class StringSource
    extends SimpleJavaFileObject {
        private final String content;

        public StringSource(URI uri, String content) {
            super(uri, JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }
}

