/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Yield
extends Instruction {
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);
    private final Switch swtch;

    public Yield(Switch swtch, Instruction value) {
        this.swtch = swtch;
        this.value.set(value);
    }

    public Instruction getValue() {
        return this.value.get();
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.END_POINT_UNREACHABLE.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitYield(this, ctx);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.swtch.addYield(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        this.swtch.remYield(this);
    }

    public Switch getSwitch() {
        return this.swtch;
    }
}

