/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apiguardian.api.API;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Context;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Result;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class Throwable
extends ChildElement<Result, Throwable> {
    public static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_JAVA, "throwable");
    public static final QualifiedName TYPE = QualifiedName.of(Namespace.REPORTING_JAVA, "type");
    private static final QualifiedName ASSERTION_ERROR = QualifiedName.of(Namespace.REPORTING_JAVA, "assertionError");

    Throwable(Context context) {
        super(context, ELEMENT);
    }

    Throwable withThrowable(java.lang.Throwable throwable) {
        this.withAttribute(TYPE, throwable.getClass().getName());
        this.withAttribute(ASSERTION_ERROR, String.valueOf(throwable instanceof AssertionError));
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            throwable.printStackTrace(writer);
        }
        this.withCDataSection(stringWriter.toString());
        return this;
    }
}

