/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.utils.JavaPropExtractGenerator;
import net.covers1624.jdkutils.utils.JavaPropExtractor;
import net.covers1624.quack.platform.Architecture;
import net.covers1624.quack.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public class JavaInstall {
    public final JavaVersion langVersion;
    public final Path javaHome;
    public final String vendor;
    public final String implName;
    public final String implVersion;
    public final String runtimeName;
    public final String runtimeVersion;
    public final Architecture architecture;
    public final boolean isOpenJ9;
    public final boolean hasCompiler;

    public JavaInstall(Path javaHome, String vendor, String implName, String implVersion, String runtimeName, String runtimeVersion, Architecture architecture) {
        this.langVersion = Objects.requireNonNull(JavaVersion.parse(implVersion), "Unable to parse java version: " + implVersion);
        this.javaHome = javaHome;
        this.vendor = vendor;
        this.implName = implName;
        this.implVersion = implVersion;
        this.runtimeName = runtimeName;
        this.runtimeVersion = runtimeVersion;
        this.architecture = architecture;
        this.isOpenJ9 = implName.contains("J9");
        this.hasCompiler = Files.exists(JavaInstall.getExecutable(javaHome, "javac"), new LinkOption[0]);
    }

    public static Path getBinDirectory(Path installationDir) {
        return JavaInstall.getHomeDirectory(installationDir).resolve("bin");
    }

    public static Path getHomeDirectory(Path installationDir) {
        if (OperatingSystem.current().isMacos()) {
            return installationDir.resolve("Contents/Home");
        }
        return installationDir;
    }

    public static Path getJavaExecutable(Path homeDir, boolean useJavaw) {
        OperatingSystem os = OperatingSystem.current();
        return JavaInstall.getExecutable(homeDir, os.isWindows() && useJavaw ? "javaw" : "java");
    }

    public static Path getExecutable(Path homeDir, String executable) {
        return homeDir.resolve("bin").resolve(OperatingSystem.current().exeSuffix(executable));
    }

    @Nullable
    public static JavaInstall parse(Path executable) {
        Map<String, String> properties = JavaPropExtractor.extractProperties(executable, Arrays.asList(JavaPropExtractGenerator.DEFAULTS));
        if (properties == null) {
            return null;
        }
        Path javaHome = Paths.get(Objects.requireNonNull(properties.get("java.home"), "Missing 'java.home' property for vm: " + executable), new String[0]).toAbsolutePath();
        if (javaHome.getFileName().toString().equals("jre") && Files.exists(javaHome.getParent().resolve("bin"), new LinkOption[0])) {
            javaHome = javaHome.getParent();
        }
        return new JavaInstall(javaHome, Objects.requireNonNull(properties.get("java.vendor"), "Missing 'java.vendor' property for vm: " + executable), Objects.requireNonNull(properties.get("java.vm.name"), "Missing 'java.name' property for vm: " + executable), Objects.requireNonNull(properties.get("java.version"), "Missing 'java.version' property for vm: " + executable), Objects.requireNonNull(properties.get("java.runtime.name"), "Missing 'java.runtime.name' property for vm: " + executable), Objects.requireNonNull(properties.get("java.runtime.version"), "Missing 'java.runtime.version' property for vm: " + executable), Architecture.parse((String)Objects.requireNonNull(properties.get("os.arch"), "Missing 'os.arch' property for vm: " + executable)));
    }

    public String toString() {
        return "JavaInstall{langVersion=" + (Object)((Object)this.langVersion) + ", javaHome=" + this.javaHome + ", vendor='" + this.vendor + '\'' + ", implName='" + this.implName + '\'' + ", implVersion='" + this.implVersion + '\'' + ", runtimeName='" + this.runtimeName + '\'' + ", runtimeVersion='" + this.runtimeVersion + '\'' + ", architecture=" + this.architecture + ", isOpenJ9=" + this.isOpenJ9 + ", hasCompiler=" + this.hasCompiler + '}';
    }
}

