package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 28/5/21.
 */
public final class TryFinally extends TryInstruction {

    private final InstructionSlot<BlockContainer> tryBody = new InstructionSlot<>(this);
    private final InstructionSlot<BlockContainer> finallyBody = new InstructionSlot<>(this);

    public TryFinally(BlockContainer tryBody, BlockContainer finallyBody) {
        setTryBody(tryBody);
        setFinallyBody(finallyBody);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTryFinally(this, ctx);
    }

    //@formatter:off1
    public BlockContainer getFinallyBody() { return finallyBody.get(); }
    public void setFinallyBody(BlockContainer finallyBody) { this.finallyBody.set(finallyBody); }
    @Override public BlockContainer getTryBody() { return tryBody.get(); }
    @Override public void setTryBody(BlockContainer tryBody) { this.tryBody.set(tryBody); }
    //@formatter:on
}
