/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.api;

import java.util.Objects;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.JavaVersion;

public class VersionFilter {
    private static final JavaVersion CURRENT = Objects.requireNonNull(JavaVersion.parse((String)System.getProperty("java.version")));

    public static boolean matchesCurrentJVM(String pattern) {
        return VersionFilter.matches(pattern, CURRENT.ordinal() + 1);
    }

    public static boolean matches(String pattern, int version) {
        if (pattern.isEmpty()) {
            return true;
        }
        for (String elem : pattern.split(",")) {
            elem = " " + elem + " ";
            String[] range = (String[])FastStream.of((Object[])elem.split("-")).map(String::trim).toArray((Object[])new String[0]);
            if (range.length == 1) {
                if (Integer.parseInt(range[0]) != version) continue;
                return true;
            }
            if (range.length == 2) {
                if (!range[0].isEmpty() && Integer.parseInt(range[0]) > version || !range[1].isEmpty() && Integer.parseInt(range[1]) < version) continue;
                return true;
            }
            throw new IllegalArgumentException("Invalid version filter: " + pattern);
        }
        return false;
    }
}

