/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.asm;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class OrderedTextifier
extends Textifier {
    private final Map<Label, String> orderedLabels = new HashMap<Label, String>();
    private final List<PendingLabel> pendingLabels = new ArrayList<PendingLabel>();

    public static void main(String[] args) throws IOException {
        Path path = Paths.get(String.join((CharSequence)" ", args), new String[0]);
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            ClassReader reader = new ClassReader(is);
            System.out.println(OrderedTextifier.textifyClass(v -> reader.accept(v, 0)));
        }
    }

    public static String textifyClass(Consumer<ClassVisitor> func) {
        OrderedTextifier textifier = new OrderedTextifier();
        func.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)textifier, null));
        return OrderedTextifier.toString(textifier);
    }

    public static String textifyMethod(Consumer<MethodVisitor> func) {
        OrderedTextifier textifier = new OrderedTextifier();
        func.accept((MethodVisitor)new TraceMethodVisitor(null, (Printer)textifier));
        return OrderedTextifier.toString(textifier);
    }

    public static String textify(ClassNode cNode) {
        return OrderedTextifier.textifyClass(arg_0 -> ((ClassNode)cNode).accept(arg_0));
    }

    public static String textify(MethodNode mNode) {
        return OrderedTextifier.textifyMethod(arg_0 -> ((MethodNode)mNode).accept(arg_0));
    }

    private static String toString(Textifier textifier) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        textifier.print(pw);
        return sw.toString();
    }

    public OrderedTextifier() {
        super(589824);
    }

    public void visitLabel(Label label) {
        String labelName = "L" + this.orderedLabels.size();
        this.orderedLabels.put(label, labelName);
        super.visitLabel(label);
    }

    protected void appendLabel(Label label) {
        String name = this.orderedLabels.get(label);
        if (name != null) {
            this.stringBuilder.append(name);
            return;
        }
        PendingLabel pending = new PendingLabel(this.text.size(), this.stringBuilder.length(), label, "PENDING_" + String.valueOf(label));
        this.pendingLabels.add(pending);
        this.stringBuilder.append(pending.tempName);
    }

    public void visitMethodEnd() {
        super.visitMethodEnd();
        if (this.pendingLabels.isEmpty()) {
            return;
        }
        for (PendingLabel pending : this.pendingLabels.reversed()) {
            String line = (String)this.text.get(pending.line);
            if (!line.startsWith(pending.tempName, pending.idx)) {
                throw new IllegalStateException("Char offset invalid.");
            }
            this.text.set(pending.line, line.substring(0, pending.idx) + this.orderedLabels.get(pending.label) + line.substring(pending.idx + pending.tempName.length()));
        }
    }

    protected Textifier createTextifier() {
        return new OrderedTextifier();
    }

    private record PendingLabel(int line, int idx, Label label, String tempName) {
    }
}

