/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.type.NullConstantType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;

public class WildcardType
extends ReferenceType {
    protected ReferenceType upperBound;
    private final ReferenceType lowerBound;

    protected WildcardType(ReferenceType upperBound, ReferenceType lowerBound) {
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
    }

    @Override
    public ReferenceType getUpperBound() {
        return this.upperBound;
    }

    @Override
    public ReferenceType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public ReferenceType getSuperType() {
        return this.upperBound;
    }

    public boolean isSuper() {
        return this.lowerBound != NullConstantType.INSTANCE;
    }

    public boolean isInfinite() {
        return false;
    }

    public static WildcardType createExtends(ReferenceType upperBound) {
        return new WildcardType(upperBound, NullConstantType.INSTANCE);
    }

    public static WildcardType createSuper(ReferenceType lowerBound) {
        return new WildcardType(TypeSystem.objectType(lowerBound), lowerBound);
    }

    @Override
    public String getName() {
        return "?";
    }

    @Override
    public String getFullName() {
        if (this.isSuper()) {
            return "? super " + this.getLowerBound().getFullName();
        }
        if (TypeSystem.isObject(this.upperBound)) {
            return "?";
        }
        return "? extends " + this.getUpperBound().getFullName();
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) || this.getUpperBound().mentions(type) || this.getLowerBound().mentions(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WildcardType)) {
            return false;
        }
        WildcardType other = (WildcardType)o;
        return this.upperBound.equals(other.upperBound) && this.lowerBound.equals(other.lowerBound);
    }

    public int hashCode() {
        int result = this.upperBound.hashCode();
        result = 31 * result + this.lowerBound.hashCode();
        return result;
    }
}

