package net.covers1624.coffeegrinder.type;

import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

/**
 * Created by covers1624 on 21/2/22.
 */
public class ParameterizedField extends Field {

    private final ParameterizedClass outer;
    private final Field unboundField;
    private final AType boundType;

    public ParameterizedField(ParameterizedClass outer, Field unboundField, AType boundType) {
        this.outer = outer;
        this.unboundField = unboundField;
        this.boundType = boundType;
    }

    //@formatter:off
    @Override public String getName() { return unboundField.getName(); }
    @Override public AType getType() { return boundType; }
    @Override public EnumBitSet<AccessFlag> getAccessFlags() { return unboundField.getAccessFlags(); }
    @Nullable @Override public Object getConstantValue() { return unboundField.getConstantValue(); }
    @Override public Field asRaw() { return unboundField.asRaw(); }
    @Override public Field getDeclaration() { return unboundField; }
    @Override public Type getDescriptor() { return unboundField.getDescriptor(); }
    @Override public ClassType getDeclaringClass() { return outer; }
    //@formatter:on
}
