package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 3/10/21.
 */
public final class DoWhileLoop extends AbstractLoop {

    private final InstructionSlot<BlockContainer> body = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> condition = new InstructionSlot<>(this);

    public DoWhileLoop(BlockContainer body, Instruction condition) {
        this.condition.set(condition);
        this.body.set(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = super.computeFlags();
        if (LdcMatching.matchLdcBoolean(getCondition(), true) == null) {
            flags.clear(InstructionFlag.END_POINT_UNREACHABLE);
        }
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitDoWhileLoop(this, ctx);
    }

    //@formatter:off
    public Instruction getCondition() { return condition.get(); }
    public void setCondition(Instruction condition) { this.condition.set(condition); }
    @Override public BlockContainer getBody() { return body.get(); }
    //@formatter:on
}
