package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;

import java.util.List;

/**
 * Created by covers1624 on 11/8/21.
 */
public class SwitchInlining implements MethodTransformer {

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        List<Switch> switches = function.descendantsToList(Switch.class);

        for (Switch aSwitch : switches) {
            BlockContainer switchContainer = aSwitch.getBody();
            ctx.pushStep("Inline switch sections " + switchContainer.getEntryPoint().getName());

            for (SwitchTable.SwitchSection section : aSwitch.getSwitchTable().sections) {
                SwitchTable.SwitchSection nextSibling = (SwitchTable.SwitchSection) section.getNextSiblingOrNull();
                if (!(section.getBody() instanceof Branch branch)) continue;

                Block target = branch.getTargetBlock();
                if (target.getIncomingEdgeCount() != 1) continue;

                branch.replaceWith(target);
                if (nextSibling == null) continue;

                if (!(target.instructions.last() instanceof Branch lastBranch)) continue;
                if (BranchLeaveMatching.matchBranch(nextSibling.getBody(), lastBranch.getTargetBlock()) == null) continue;
                lastBranch.remove();
            }

            ctx.popStep();
        }
    }
}
