/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.flow.Dominance;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.TransformerUtils;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class SwitchDetection
implements BlockTransformer {
    private static final ControlFlowNode NO_EXIT_POINT = new ControlFlowNode();
    private BlockTransformContext ctx;

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        this.ctx = ctx;
        Instruction last = (Instruction)block.instructions.lastOrDefault();
        if (last instanceof SwitchTable) {
            this.transformSwitch(block, (SwitchTable)last);
        }
    }

    private void transformSwitch(Block block, SwitchTable switchTable) {
        ControlFlowNode entryPoint = this.ctx.getControlFlowNode();
        LinkedList<Block> switchNodes = new LinkedList<Block>();
        Block exitBlock = this.extendSwitch(entryPoint, switchNodes);
        assert (switchNodes.getFirst() == block);
        switchNodes.removeFirst();
        BlockContainer switchContainer = new BlockContainer();
        Block newEntryPoint = (Block)new Block(block.getSubName("switch")).withOffsets(switchTable);
        newEntryPoint.instructions.add(switchTable);
        switchNodes.addFirst(newEntryPoint);
        block.instructions.add((Instruction)new Switch(switchTable.getValue(), switchContainer).withOffsets(switchTable));
        switchTable.setValue(new Nop());
        if (exitBlock != null) {
            block.instructions.add(new Branch(exitBlock));
        }
        TransformerUtils.moveBlocksIntoContainer(switchNodes, (BlockContainer)block.getParent(), switchContainer, exitBlock);
    }

    @Nullable
    private Block extendSwitch(ControlFlowNode entryPoint, List<Block> switchNodes) {
        LoopContext loopCtx = new LoopContext(this.ctx.getControlFlowGraph(), entryPoint);
        HashSet<ControlFlowNode> inSwitchNodes = new HashSet<ControlFlowNode>();
        loopCtx.getDominatorTreeChildren(entryPoint).forEach(c -> this.addPredecessorsInDominatorTree(entryPoint, (ControlFlowNode)c, (Set<ControlFlowNode>)inSwitchNodes));
        ControlFlowNode exitNode = SwitchDetection.pickExitViaBytecodeOffset(entryPoint, loopCtx);
        if (exitNode == NO_EXIT_POINT) {
            exitNode = this.computeImmediatePostDominator(entryPoint, inSwitchNodes, loopCtx);
        }
        ControlFlowNode finalExitNode = exitNode;
        entryPoint.streamPreOrder(e -> loopCtx.getDominatorTreeChildren((ControlFlowNode)e).filter(c -> c != finalExitNode)).forEach(e -> switchNodes.add(e.block));
        assert (FastStream.of(inSwitchNodes).map(ControlFlowNode::getBlock).allMatch(switchNodes::contains));
        return exitNode.block;
    }

    private void addPredecessorsInDominatorTree(ControlFlowNode head, ControlFlowNode n, Set<ControlFlowNode> preds) {
        if (n == head) {
            return;
        }
        for (ControlFlowNode pred : n.getPredecessors()) {
            if (!head.dominates(pred) || !preds.add(pred)) continue;
            this.addPredecessorsInDominatorTree(head, pred, preds);
        }
    }

    private ControlFlowNode computeImmediatePostDominator(ControlFlowNode entryPoint, Set<ControlFlowNode> excludingNodes, LoopContext loopCtx) {
        HashBiMap map = HashBiMap.create();
        ControlFlowNode revExitNode = (ControlFlowNode)map.computeIfAbsent((Object)NO_EXIT_POINT, ControlFlowNode::new);
        entryPoint.streamPreOrder(loopCtx::getDominatorTreeChildren).forEach(arg_0 -> this.lambda$computeImmediatePostDominator$4((BiMap)map, loopCtx, entryPoint, revExitNode, arg_0));
        if (revExitNode.getSuccessors().isEmpty()) {
            return NO_EXIT_POINT;
        }
        Dominance.computeDominance(revExitNode);
        ControlFlowNode revEntryPoint = Objects.requireNonNull((ControlFlowNode)map.get((Object)entryPoint));
        assert (revEntryPoint.isReachable());
        ControlFlowNode revPostDominator = revEntryPoint.getImmediateDominator();
        while (excludingNodes.contains(map.inverse().get((Object)revPostDominator))) {
            revPostDominator = revPostDominator.getImmediateDominator();
        }
        return (ControlFlowNode)map.inverse().get((Object)revPostDominator);
    }

    private static ControlFlowNode pickExitViaBytecodeOffset(ControlFlowNode entryPoint, LoopContext loopContext) {
        ControlFlowNode node = (ControlFlowNode)loopContext.getDominatorTreeChildren(entryPoint).maxByOrDefault(e -> e.getBlock().getBytecodeOffset());
        if (node == null) {
            return NO_EXIT_POINT;
        }
        if (node.getPredecessors().size() <= 1) {
            return NO_EXIT_POINT;
        }
        return node;
    }

    @Nullable
    public static Branch matchIncrementBlock(Block block) {
        Object object = block.instructions.last();
        if (!(object instanceof Branch)) {
            return null;
        }
        Branch branch = (Branch)object;
        if (!block.descendantsOfType(LocalReference.class).filter(e -> e.variable.getKind() == LocalVariable.VariableKind.STACK_SLOT).flatMap(e -> e.variable.getReferences()).allMatch(e -> e.isDescendantOf(block))) {
            return null;
        }
        return branch;
    }

    private static boolean matchDoWhileConditionBlock(Block block, Block loopHead) {
        Branch target;
        IfInstruction ifInstruction;
        if (block.instructions.size() < 2) {
            return false;
        }
        Instruction secondToLast = block.instructions.secondToLastOrDefault();
        if (!(secondToLast instanceof IfInstruction) || !((ifInstruction = (IfInstruction)secondToLast).getFalseInsn() instanceof Nop)) {
            return false;
        }
        Instruction instruction = ifInstruction.getTrueInsn();
        return instruction instanceof Branch && loopHead == (target = (Branch)instruction).getTargetBlock();
    }

    private /* synthetic */ void lambda$computeImmediatePostDominator$4(BiMap map, LoopContext loopCtx, ControlFlowNode entryPoint, ControlFlowNode revExitNode, ControlFlowNode node) {
        ControlFlowNode revNode = (ControlFlowNode)map.computeIfAbsent((Object)node, ControlFlowNode::new);
        for (ControlFlowNode succ : node.getSuccessors()) {
            if (loopCtx.matchContinue(succ, 1)) continue;
            ControlFlowNode succNode = (ControlFlowNode)map.computeIfAbsent((Object)succ, ControlFlowNode::new);
            succNode.addEdgeTo(revNode);
            if (entryPoint.dominates(succ) && !this.ctx.getControlFlowGraph().hasDirectExit(node)) continue;
            revExitNode.addEdgeTo(succNode);
        }
    }

    public static class LoopContext {
        private final Object2IntMap<ControlFlowNode> continueDepth = new Object2IntOpenHashMap();

        public LoopContext(ControlFlowGraph cfg, ControlFlowNode contextNode) {
            ArrayList loopHeads = new ArrayList();
            contextNode.getSuccessors().forEach(e -> this.analyze(contextNode, (ControlFlowNode)e, loopHeads));
            cfg.resetVisited();
            int l = 1;
            for (ControlFlowNode loopHead : FastStream.of(loopHeads).sorted(Comparator.comparingInt(e -> e.postOrderNumber))) {
                this.continueDepth.put((Object)LoopContext.findContinue(loopHead), l++);
            }
        }

        private void analyze(ControlFlowNode contextNode, ControlFlowNode n, List<ControlFlowNode> loopHeads) {
            if (n.visited) {
                return;
            }
            n.visited = true;
            if (n.dominates(contextNode)) {
                loopHeads.add(n);
            } else {
                n.getSuccessors().forEach(e -> this.analyze(contextNode, (ControlFlowNode)e, loopHeads));
            }
        }

        private static ControlFlowNode findContinue(ControlFlowNode loopHead) {
            Branch target;
            ControlFlowNode pred = (ControlFlowNode)FastStream.of(loopHead.getPredecessors()).filter(e -> e != loopHead && loopHead.dominates((ControlFlowNode)e)).onlyOrDefault();
            if (pred == null) {
                return loopHead;
            }
            assert (pred.block != null);
            if (pred.getSuccessors().size() == 1 && (target = SwitchDetection.matchIncrementBlock(pred.block)) != null && target.getTargetBlock() == loopHead.block) {
                return pred;
            }
            if (pred.getSuccessors().size() <= 2 && loopHead.block != null && SwitchDetection.matchDoWhileConditionBlock(pred.block, loopHead.block)) {
                return pred;
            }
            return loopHead;
        }

        public boolean matchContinue(ControlFlowNode node, int depth) {
            return this.continueDepth.getOrDefault((Object)node, -1) == depth;
        }

        public FastStream<ControlFlowNode> getDominatorTreeChildren(ControlFlowNode node) {
            return FastStream.of(node.getDominatorTreeChildren()).filter(e -> !this.continueDepth.containsKey(e));
        }
    }
}

