/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionCollection<T extends Instruction>
extends InstructionSlot<T>
implements FastStream<T> {
    @Nullable
    InstructionSlot<T> head;
    @Nullable
    InstructionSlot<T> tail;
    private int size;

    public InstructionCollection(Instruction parent) {
        super(parent);
    }

    @Override
    void onConnected() {
        InstructionSlot<Object> slot = this.head;
        while (slot != null) {
            slot.onConnected();
            if (slot == this.tail) break;
            slot = slot.nextSibling;
        }
    }

    public void addFirst(T value) {
        if (this.head == null) {
            this.add(value);
        } else {
            ((Instruction)this.head.get()).insertBefore((Instruction)value);
        }
    }

    public void add(T value) {
        this.add(value, new CollectionSlot(this.parent));
    }

    public void addAllFirst(Iterable<? extends T> values) {
        Instruction pointer = null;
        for (Instruction t : values) {
            if (pointer == null) {
                this.addFirst(t);
            } else {
                pointer.insertAfter(t);
            }
            pointer = t;
        }
    }

    public void addAll(Iterable<? extends T> values) {
        for (Instruction t : values) {
            this.add(t);
        }
    }

    @Nullable
    public T secondToLastOrDefault() {
        if (this.tail == null) {
            return null;
        }
        if (this.tail == this.head) {
            return null;
        }
        return (T)((Instruction)SneakyUtils.unsafeCast((Object)((Instruction)this.tail.get()).getPrevSiblingOrNull()));
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            Instruction insn = (Instruction)iterator.next();
            insn.remove();
        }
    }

    protected void add(T value, CollectionSlot newSlot) {
        ++this.size;
        if (this.head == null) {
            assert (this.tail == null) : "Collection in broken state, expected tail to be null";
            newSlot.prevSibling = this;
            this.head = newSlot;
        } else {
            assert (this.tail != null) : "Collection in broken state, expected tail to be non-null";
            this.tail.nextSibling = newSlot;
            newSlot.prevSibling = this.tail;
        }
        newSlot.nextSibling = this.nextSibling;
        this.tail = newSlot;
        newSlot.set((Instruction)value);
    }

    @Override
    public T getValueOrNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    InstructionSlot<?> onNext() {
        if (this.head != null) {
            return this.head.onNext();
        }
        if (this.nextSibling != null) {
            return this.nextSibling.onNext();
        }
        return null;
    }

    @Override
    @Nullable
    InstructionSlot<?> onPrevious(@Nullable InstructionSlot<?> inSlot) {
        if (this.head != inSlot && this.tail != null) {
            return this.tail.onPrevious(inSlot);
        }
        if (this.prevSibling != null) {
            return this.prevSibling.onPrevious(inSlot);
        }
        return null;
    }

    @Override
    protected void checkInvariant() {
        super.checkInvariant();
        assert (this.head == null || this.head.prevSibling == this);
        assert (this.tail == null || this.tail.nextSibling == this.nextSibling);
        InstructionSlot<Object> slot = this.head;
        while (slot != null) {
            slot.checkInvariant();
            slot = slot.nextSibling;
        }
    }

    @Override
    public void set(Instruction value) {
        throw new UnsupportedOperationException();
    }

    public int count() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            @Nullable
            InstructionSlot<?> next;
            {
                this.next = InstructionCollection.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                assert (this.next != null);
                InstructionSlot<?> curr = this.next;
                this.next = this.next != InstructionCollection.this.tail ? this.next.nextSibling : null;
                return (Instruction)SneakyUtils.unsafeCast(curr.get());
            }
        };
    }

    protected class CollectionSlot
    extends InstructionSlot<T> {
        public CollectionSlot(Instruction parent) {
            super(parent, false);
        }

        @Override
        void remove() {
            --InstructionCollection.this.size;
            assert (this.value != null);
            if (InstructionCollection.this.head == this) {
                if (InstructionCollection.this.head == InstructionCollection.this.tail) {
                    InstructionCollection.this.head = null;
                    InstructionCollection.this.tail = null;
                } else {
                    assert (this.nextSibling != null);
                    assert (this.prevSibling == InstructionCollection.this);
                    InstructionCollection.this.head = (InstructionSlot)SneakyUtils.unsafeCast((Object)this.nextSibling);
                    InstructionCollection.this.head.prevSibling = InstructionCollection.this;
                }
            } else if (InstructionCollection.this.tail == this) {
                assert (this.prevSibling != null);
                InstructionCollection.this.tail = (InstructionSlot)SneakyUtils.unsafeCast((Object)this.prevSibling);
                this.prevSibling.nextSibling = this.nextSibling;
            } else {
                assert (this.nextSibling != null);
                assert (this.prevSibling != null);
                this.nextSibling.prevSibling = this.prevSibling;
                this.prevSibling.nextSibling = this.nextSibling;
            }
            this.parent.onChildModified();
            this.parent.invalidateFlags();
            if (this.value.isConnected()) {
                this.value.releaseRef();
            }
            this.nextSibling = null;
            this.prevSibling = null;
        }

        @Override
        void insertBefore(Instruction value) {
            ++InstructionCollection.this.size;
            CollectionSlot newInsn = new CollectionSlot(this.parent);
            if (InstructionCollection.this.head == this) {
                InstructionCollection.this.head = newInsn;
                newInsn.prevSibling = InstructionCollection.this;
            } else {
                assert (this.prevSibling != null);
                newInsn.prevSibling = this.prevSibling;
                this.prevSibling.nextSibling = newInsn;
            }
            newInsn.nextSibling = this;
            this.prevSibling = newInsn;
            newInsn.set(value);
        }

        @Override
        void insertAfter(Instruction value) {
            ++InstructionCollection.this.size;
            CollectionSlot newInsn = new CollectionSlot(this.parent);
            if (InstructionCollection.this.tail == this) {
                InstructionCollection.this.tail = newInsn;
                newInsn.nextSibling = InstructionCollection.this.nextSibling;
            } else {
                assert (this.nextSibling != null);
                newInsn.nextSibling = this.nextSibling;
                this.nextSibling.prevSibling = newInsn;
            }
            newInsn.prevSibling = this;
            this.nextSibling = newInsn;
            newInsn.set(value);
        }

        @Override
        protected void checkInvariant() {
            if (this == InstructionCollection.this.head) {
                assert (this.prevSibling == InstructionCollection.this);
            } else {
                assert (this.prevSibling != null);
                assert (this.prevSibling.nextSibling == this);
            }
            if (this == InstructionCollection.this.tail) {
                assert (this.nextSibling == InstructionCollection.this.nextSibling);
            } else {
                assert (this.nextSibling != null);
                assert (this.nextSibling.prevSibling == this);
            }
        }

        @Override
        boolean isInCollection() {
            return true;
        }
    }
}

