/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.JavaVersion;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public abstract class ClassType
extends ReferenceType
implements ITypeParameterizedMember {
    protected final Supplier<Map<String, Field>> fieldsLookup = Util.singleMemoize(() -> FastStream.of(this.getFields()).toImmutableMap(e -> e.getName() + String.valueOf(e.getDescriptor()), e -> e));
    protected final Supplier<Map<String, Method>> methodsLookup = Util.singleMemoize(() -> FastStream.of(this.getMethods()).toImmutableMap(e -> e.getName() + String.valueOf(e.getDescriptor()), e -> e));

    public abstract ClassType getSuperClass();

    public abstract List<ClassType> getInterfaces();

    public abstract List<ClassType> getNestedClasses();

    public abstract List<Field> getFields();

    @Override
    public abstract List<Method> getMethods();

    public abstract DeclType getDeclType();

    public abstract String getPackage();

    public abstract EnumBitSet<AccessFlag> getAccessFlags();

    public abstract Optional<ClassType> getEnclosingClass();

    public abstract Optional<Method> getEnclosingMethod();

    public AnnotationSupplier getAnnotationSupplier() {
        throw new UnsupportedOperationException();
    }

    public List<ElementType> getAnnotationTargets() {
        throw new UnsupportedOperationException();
    }

    public abstract Type getDescriptor();

    public abstract ClassType getDeclaration();

    public abstract ClassType asRaw();

    public JavaVersion getClassVersion() {
        return this.getDeclaration().getClassVersion();
    }

    public final boolean isInterface() {
        return this.getAccessFlags().get(AccessFlag.INTERFACE);
    }

    public final boolean isStatic() {
        return this.getAccessFlags().get(AccessFlag.STATIC);
    }

    public final boolean isFinal() {
        return this.getAccessFlags().get(AccessFlag.FINAL);
    }

    public final boolean isEnum() {
        return this.getAccessFlags().get(AccessFlag.ENUM);
    }

    public final boolean isSynthetic() {
        return this.getAccessFlags().get(AccessFlag.SYNTHETIC);
    }

    public List<ClassType> getPermittedSubclasses() {
        return this.getDeclaration().getPermittedSubclasses();
    }

    public TypeResolver getTypeResolver() {
        return this.getDeclaration().getTypeResolver();
    }

    @Override
    @Nullable
    public TypeParameter resolveTypeParameter(String identifier) {
        for (TypeParameter param : this.getTypeParameters()) {
            if (!param.getName().equals(identifier)) continue;
            return param;
        }
        if (this.getEnclosingMethod().isPresent()) {
            return this.getEnclosingMethod().get().resolveTypeParameter(identifier);
        }
        if (this.getEnclosingClass().isPresent()) {
            return this.getEnclosingClass().get().resolveTypeParameter(identifier);
        }
        return null;
    }

    @Override
    public ReferenceType getSuperType() {
        return this.getSuperClass();
    }

    public FastStream<ClassType> getDirectSuperTypes() {
        if (TypeSystem.isObject(this)) {
            return FastStream.empty();
        }
        return FastStream.of((Object)this.getSuperClass()).concat(this.getInterfaces());
    }

    @Override
    @Nullable
    public Field resolveField(String name, Type desc) {
        Field field = this.fieldsLookup.get().get(name + String.valueOf(desc));
        if (field != null) {
            return field;
        }
        return super.resolveField(name, desc);
    }

    @Override
    @Nullable
    public Method resolveMethod(String name, Type desc) {
        Method method = this.methodsLookup.get().get(name + String.valueOf(desc));
        if (method != null && !method.isBridge()) {
            return method;
        }
        return super.resolveMethod(name, desc);
    }

    @Nullable
    public Field findConstant(Object value, boolean isStatic) {
        return this.getDeclaration().findConstant(value, isStatic);
    }

    @Override
    @Nullable
    public Method getFunctionalInterfaceMethod() {
        if (!this.isInterface()) {
            throw new IllegalArgumentException("Not an interface");
        }
        Method[] options = (Method[])FastStream.of(this.getAllMethods()).filter(Method::isAbstract).filter(m -> this.getSuperClass().resolveMethod(m.getName(), m.getDescriptor()) == null).toArray((Object[])new Method[0]);
        if (options.length == 0) {
            return null;
        }
        if (options.length == 1) {
            return options[0];
        }
        Method m2 = ClassType.selectMethodWithSubsignatureOfAll(options);
        return m2;
    }

    @Nullable
    private static Method selectMethodWithSubsignatureOfAll(Method[] options) {
        block0: for (int i = 0; i < options.length; ++i) {
            Method m = options[i];
            for (int j = 0; j < options.length; ++j) {
                if (j != i && !ClassType.isSubsignatureOf(m, options[j])) continue block0;
            }
            return m;
        }
        return null;
    }

    private static boolean isSubsignatureOf(Method s, Method t) {
        for (int i = 0; i < s.getParameters().size(); ++i) {
            AType paramS = s.getParameters().get(i).getType();
            AType paramT = t.getParameters().get(i).getType();
            if (!(paramS instanceof ReferenceType)) continue;
            if (TypeSystem.lub((ReferenceType)paramS, (ReferenceType)paramT).equals(paramS)) continue;
            return false;
        }
        AType retS = s.getReturnType();
        AType retT = t.getReturnType();
        return TypeSystem.isAssignableTo(retS, retT);
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) || this.getDeclaration() == type;
    }

    public ClassType getTopLevelClass() {
        ClassType type = this.getEnclosingClass().map(ClassType::getTopLevelClass).orElse(this);
        assert (type.getDeclType() == DeclType.TOP_LEVEL);
        return type;
    }

    public String toString() {
        return this.getFullName();
    }

    public static enum DeclType {
        TOP_LEVEL,
        INNER,
        LOCAL,
        ANONYMOUS;


        public boolean isLocalOrAnonymous() {
            return this == LOCAL || this == ANONYMOUS;
        }
    }
}

