package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;

/**
 * Created by covers1624 on 10/5/21.
 */
public class BlockTransformContext extends MethodTransformContext {

    /**
     * The {@link ControlFlowNode} corresponding to the block being processed.
     * This should be identical to <code>controlFlowGraph.getNode(block)</code>
     * <p>
     * Note: Control Flow Graph is not up-to-date, but was created at the start of block
     * transforms. (before loop detection)
     */
    private final ControlFlowNode controlFlowNode;

    /**
     * The Control Flow Graph.
     * <p>
     * Note: Control Flow Graph is not up-to-date, but was created at the start of block
     * transforms. (before loop detection)
     */
    private final ControlFlowGraph controlFlowGraph;

    public BlockTransformContext(MethodTransformContext other, ControlFlowNode node, ControlFlowGraph graph) {
        super(other);
        this.controlFlowNode = node;
        this.controlFlowGraph = graph;
    }

    //@formatter:off
    public ControlFlowNode getControlFlowNode() { return controlFlowNode; }
    public ControlFlowGraph getControlFlowGraph() { return controlFlowGraph; }
    //@formatter:on
}
