package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.type.TypeSystem;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 11/10/25.
 */
public class BoxingMatching {

    @Nullable
    public static Invoke matchUnboxing(@Nullable Instruction insn) {
        if (!(insn instanceof Invoke invoke)) return null;

        var unboxedType = TypeSystem.unbox(invoke.getTargetClassType());
        if (unboxedType == null) return null;

        var method = invoke.getMethod();
        if (!method.getParameters().isEmpty()) return null;
        if (method.getReturnType() != unboxedType) return null;
        if (!method.getName().equals(unboxedType.getUnboxMethodName())) return null;

        return invoke;
    }
}
