package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;

import static net.covers1624.coffeegrinder.bytecode.matching.IfMatching.matchNopFalseIf;
import static net.covers1624.coffeegrinder.bytecode.matching.LdcMatching.matchLdcBoolean;

/**
 * Created by covers1624 on 11/23/25.
 */
public class BooleanLogicYields implements StatementTransformer {

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        if (!(matchNopFalseIf(statement) instanceof IfInstruction ifInsn) || !isBooleanLogic(ifInsn.getCondition())) return;

        if (!(ifInsn.getTrueInsn() instanceof Yield trueYield) || matchLdcBoolean(trueYield.getValue(), true) == null) return;

        if (!(ifInsn.getNextSiblingOrNull() instanceof Yield falseYield) || matchLdcBoolean(falseYield.getValue(), false) == null) return;

        ctx.pushStep("Simplify boolean yield");
        statement.replaceWith(new Yield(trueYield.getSwitch(), ifInsn.getCondition()));
        falseYield.remove();
        ctx.popStep();
    }

    private static boolean isBooleanLogic(Instruction insn) {
        return insn instanceof Comparison
               || insn instanceof Binary
               || insn instanceof LogicOr
               || insn instanceof LogicAnd
               || insn instanceof LogicNot;
    }
}
