/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Leave
extends Instruction {
    private static final EnumBitSet<InstructionFlag> flags = EnumBitSet.of((Enum[])new InstructionFlag[]{InstructionFlag.END_POINT_UNREACHABLE, InstructionFlag.MAY_BRANCH});
    private final BlockContainer targetContainer;

    public Leave(BlockContainer targetContainer) {
        this.targetContainer = targetContainer;
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.targetContainer.addLeave(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        this.targetContainer.remLeave(this);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return flags;
    }

    @Override
    public Leave copy() {
        return (Leave)new Leave(this.targetContainer).withOffsets(this);
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLeave(this, ctx);
    }

    public BlockContainer getTargetContainer() {
        return Objects.requireNonNull(this.targetContainer);
    }
}

