/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.covers1624.coffeegrinder.util.resolver.JarResolver;

public class JModResolver
extends JarResolver {
    private static final int JMOD_MAJOR = 1;
    private static final int JMOD_MINOR = 0;
    private static final byte[] JMOD_HEADER = new byte[]{74, 77, 1, 0};

    public JModResolver(Path path) {
        super(path, "/classes");
    }

    @Override
    protected void validate() {
        if (Files.notExists(this.path, new LinkOption[0])) {
            throw new IllegalStateException("File does not exist.");
        }
        if (!Files.isRegularFile(this.path, new LinkOption[0])) {
            throw new IllegalStateException("Not a file.");
        }
        if (!this.path.getFileName().toString().endsWith(".jmod")) {
            throw new IllegalStateException("Expected jmod extension.");
        }
        try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
            byte[] magic = new byte[4];
            int len = is.read(magic);
            if (len != 4) {
                throw new IllegalStateException("Invalid JMOD file.");
            }
            for (int i = 0; i < 4; ++i) {
                if (magic[i] == JMOD_HEADER[i]) continue;
                if (i < 2) {
                    throw new IllegalStateException("Invalid JMOD file.");
                }
                throw new IllegalStateException("Unsupported JMOD version: " + magic[2] + "." + magic[3]);
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to read JMOD file header.", ex);
        }
    }

    @Override
    public String toString() {
        return "JModResolver(" + String.valueOf(this.path) + ")";
    }
}

