package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.debug.Stepper;
import net.covers1624.coffeegrinder.type.TypeResolver;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;

/**
 * Created by covers1624 on 5/3/22.
 */
public class TransformContextBase implements Stepper {

    private final Stepper stepper;
    private final TypeResolver typeResolver;
    private final DecompilerSettings settings;

    protected TransformContextBase(TransformContextBase other) {
        this(other.stepper, other.typeResolver, other.settings);
    }

    public TransformContextBase(Stepper stepper, TypeResolver typeResolver, DecompilerSettings settings) {
        this.stepper = stepper;
        this.typeResolver = typeResolver;
        this.settings = settings;
    }

    // @formatter:off
    public Stepper getStepper() { return stepper; }
    public TypeResolver getTypeResolver() { return typeResolver; }
    public DecompilerSettings getSettings() { return settings; }
    @Override public DebugPrintOptions getOpts() { return stepper.getOpts(); }
    @Override public void pushContext(Stepper.ContextSupplier supplier) { stepper.pushContext(supplier); }
    @Override public void popContext() { stepper.popContext(); }
    @Override @Nullable public Step pushStep(String name) { return stepper.pushStep(name); }
    @Override @Nullable public Step pushStep(String name, Step.StepContextType contextType) { return stepper.pushStep(name, contextType); }
    @Override @Nullable public Step pushStepWithContent(String name, Step.StepContextType contextType, Supplier<String> preContent) { return stepper.pushStepWithContent(name, contextType, preContent); }
    @Override public void popStep() { stepper.popStep(); }
    @Override public Step pushTiming(String name) { return stepper.pushTiming(name); }
    @Override public void popTiming() { stepper.popTiming(); }
    @Override public void except(Throwable e) { stepper.except(e); }
    @Override @Nullable public Step getRoot() { return stepper.getRoot(); }
    // @formatter:on
}
