/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.HashSet;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.Yield;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.quack.collection.FastStream;

public class SwitchExpressions
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.descendantsOfType(Switch.class).forEach(swtch -> this.transform((Instruction)swtch, ctx));
    }

    private void transform(Instruction statement, MethodTransformContext ctx) {
        if (!(statement instanceof Switch)) {
            return;
        }
        Switch sSwitch = (Switch)statement;
        BlockContainer switchBody = sSwitch.getBody();
        HashSet<LocalVariable> candidateVars = new HashSet<LocalVariable>();
        for (Leave leave : switchBody.getLeaves()) {
            Instruction instruction = leave.getPrevSiblingOrNull();
            if (!(instruction instanceof Store)) {
                return;
            }
            Store store = (Store)instruction;
            Reference reference = store.getReference();
            if (!(reference instanceof LocalReference)) {
                return;
            }
            LocalReference r = (LocalReference)reference;
            if (r.variable.getKind() != LocalVariable.VariableKind.STACK_SLOT) {
                return;
            }
            candidateVars.add(r.variable);
        }
        LocalVariable stackVar = (LocalVariable)FastStream.of(candidateVars).onlyOrDefault();
        if (stackVar == null) {
            return;
        }
        if (stackVar.getLoadCount() != 1) {
            return;
        }
        ctx.pushStep("Produce switch expression.");
        Switch newSwitch = new Switch(sSwitch.getValue(), switchBody, stackVar.getType());
        for (Leave leave : switchBody.getLeaves().toList()) {
            Store store = (Store)leave.getPrevSibling();
            leave.replaceWith(new Yield(newSwitch, store.getValue()).withOffsets(leave));
            store.remove();
        }
        sSwitch.replaceWith(new Store(new LocalReference(stackVar), newSwitch));
        ctx.popStep();
    }
}

