/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.Objects;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import org.jetbrains.annotations.Nullable;

public class ScopeVisitor<R, C>
extends InsnVisitor<R, C> {
    private Scope scope = new Scope(null, null);
    private final InsnVisitor<R, C> inner;

    public ScopeVisitor(InsnVisitor<R, C> inner) {
        this.inner = inner;
    }

    public boolean currentScopeHasDeclarations() {
        return this.scope.var != null;
    }

    public R visit(Instruction insn, C ctx) {
        if (insn.getParentOrNull() instanceof IfInstruction) {
            return (R)this.withScope(() -> insn.accept(this, ctx));
        }
        return insn.accept(this, ctx);
    }

    @Override
    public R visitDefault(Instruction insn, C ctx) {
        return insn.accept(this.inner, ctx);
    }

    @Override
    public R visitMethodDecl(MethodDecl methodDecl, C ctx) {
        return (R)this.withScope(() -> {
            methodDecl.parameters.forEach(this::declare);
            return super.visitMethodDecl(methodDecl, ctx);
        });
    }

    @Override
    public R visitBlockContainer(BlockContainer container, C ctx) {
        return this.visitWithScope(container, ctx);
    }

    @Override
    public R visitSwitchSection(SwitchTable.SwitchSection switchSection, C ctx) {
        return this.visitWithScope(switchSection, ctx);
    }

    @Override
    public R visitForLoop(ForLoop loop, C ctx) {
        return this.visitWithScope(loop, ctx);
    }

    @Override
    public R visitForEachLoop(ForEachLoop forEachLoop, C ctx) {
        return this.visitWithScope(forEachLoop, ctx);
    }

    @Override
    public R visitTryCatchHandler(TryCatch.TryCatchHandler catchHandler, C ctx) {
        return this.visitWithScope(catchHandler, ctx);
    }

    @Override
    public R visitTryWithResources(TryWithResources tryWithResources, C ctx) {
        return this.visitWithScope(tryWithResources, ctx);
    }

    private R visitWithScope(Instruction insn, C ctx) {
        return (R)this.withScope(() -> this.visitDefault(insn, ctx));
    }

    private R withScope(Supplier<R> func) {
        this.scope = new Scope(this.scope, null);
        try {
            R r = func.get();
            return r;
        }
        finally {
            while (this.scope.var != null) {
                this.scope = Objects.requireNonNull(this.scope.prev);
            }
            this.scope = Objects.requireNonNull(this.scope.prev);
        }
    }

    @Override
    public R visitLocalReference(LocalReference local, C ctx) {
        Object r = super.visitLocalReference(local, ctx);
        if (local.isConnected() && !local.isReadFrom() && !this.isDeclared(local.variable)) {
            this.declare(local.variable);
        }
        return r;
    }

    private void declare(LocalVariable var) {
        this.scope = new Scope(this.scope, var);
    }

    public boolean isDeclared(LocalVariable var) {
        Scope s = this.scope;
        while (s != null) {
            if (s.var == var) {
                return true;
            }
            s = s.prev;
        }
        return false;
    }

    public boolean isDeclared(String name) {
        return this.getVariableInScope(name) != null;
    }

    @Nullable
    public LocalVariable getVariableInScope(String name) {
        Scope s = this.scope;
        while (s != null) {
            if (s.var != null && s.var.getName().equals(name)) {
                return s.var;
            }
            s = s.prev;
        }
        return null;
    }

    private record Scope(@Nullable Scope prev, @Nullable LocalVariable var) {
    }
}

