package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 4/5/21.
 */
public final class FieldDecl extends Instruction {

    private Field field;

    private final InstructionSlot<Instruction> value = new InstructionSlot<>(this);

    public FieldDecl(Field field) {
        this.field = field;
        setValue(new Nop());
    }

    @Override
    public AType getResultType() {
        return field.getType();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitFieldDecl(this, ctx);
    }

    //@formatter:off
    public Field getField() { return field; }
    public Instruction getValue() { return value.get(); }
    public void setField(Field field) { this.field = field; }
    public void setValue(Instruction value) { this.value.set(value); }
    //@formatter:on
}
