/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core;

import java.time.LocalDateTime;
import org.apiguardian.api.API;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Context;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Attachments;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;

@API(status=API.Status.EXPERIMENTAL, since="0.2.0")
public class File
extends ChildElement<Attachments, File> {
    public static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_CORE, "file");
    public static final QualifiedName TIME = QualifiedName.of(Namespace.REPORTING_CORE, "time");
    public static final QualifiedName PATH = QualifiedName.of(Namespace.REPORTING_CORE, "path");
    public static final QualifiedName MEDIA_TYPE = QualifiedName.of(Namespace.REPORTING_CORE, "mediaType");

    File(Context context) {
        super(context, ELEMENT);
    }

    public File withTime(LocalDateTime timestamp) {
        this.withAttribute(TIME, timestamp.toString());
        return this;
    }

    public File withPath(String path) {
        this.withAttribute(PATH, path);
        return this;
    }

    public File withMediaType(String mediaType) {
        this.withAttribute(MEDIA_TYPE, mediaType);
        return this;
    }
}

