/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InvalidTreeStateException;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class InstructionSlot<T extends Instruction> {
    final Instruction parent;
    @Nullable
    Instruction value;
    @Nullable
    InstructionSlot<?> prevSibling;
    @Nullable
    InstructionSlot<?> nextSibling;

    public InstructionSlot(Instruction parent) {
        this(parent, true);
    }

    protected InstructionSlot(Instruction parent, boolean link) {
        this.parent = parent;
        if (link) {
            if (this.parent.firstChild == null) {
                assert (this.parent.lastChild == null) : "Parent in broken state, expected lastChild to be null";
                this.parent.firstChild = this;
            } else {
                assert (this.parent.lastChild != null) : "Parent in broken state, expected last child to be non-null";
                this.parent.lastChild.nextSibling = this;
                this.prevSibling = this.parent.lastChild;
            }
            this.parent.lastChild = this;
        }
    }

    public void set(Instruction value) {
        assert (!this.parent.isDescendantOf(value));
        Instruction oldValue = this.value;
        this.value = value;
        this.parent.invalidateFlags();
        this.parent.onChildModified();
        if (this.parent.isConnected()) {
            this.linkValue();
            if (oldValue != null) {
                oldValue.releaseRef();
            }
        }
    }

    private void linkValue() {
        assert (this.value != null);
        InstructionSlot<?> prevSlot = this.value.inSlot;
        this.value.inSlot = this;
        this.value.addRef();
        if (prevSlot != null && prevSlot.value == this.value) {
            prevSlot.remove();
        }
    }

    void onConnected() {
        this.linkValue();
    }

    @Nullable
    T getValueOrNull() {
        if (this.value == null) {
            throw new InvalidTreeStateException("Slot is required to have a value. Was it not set or moved?");
        }
        return (T)((Instruction)SneakyUtils.unsafeCast((Object)this.value));
    }

    public T get() {
        return (T)((Instruction)Objects.requireNonNull(this.getValueOrNull()));
    }

    protected void checkInvariant() {
        assert (this.prevSibling == null || this.prevSibling.nextSibling == this);
        assert (this.nextSibling == null || this.nextSibling.prevSibling == this);
        assert (this.value == null || this.value.inSlot == this);
    }

    @Nullable
    InstructionSlot<?> onNext() {
        return this;
    }

    @Nullable
    InstructionSlot<?> onPrevious(@Nullable InstructionSlot<?> inSlot) {
        return this;
    }

    void removeValue() {
        assert (this.value != null);
        if (this.value.isConnected()) {
            this.value.releaseRef();
        }
        this.value = null;
        this.parent.invalidateFlags();
    }

    void remove() {
        this.removeValue();
    }

    void insertBefore(Instruction value) {
        throw new UnsupportedOperationException("Instruction is not inside a collection.");
    }

    void insertAfter(Instruction value) {
        throw new UnsupportedOperationException("Instruction is not inside a collection.");
    }

    boolean isInCollection() {
        return false;
    }
}

