/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.ScopeVisitor;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;

public class VariableDeclarations
extends SimpleInsnVisitor<None>
implements MethodTransformer {
    private final Map<LocalVariable, Instruction> varDeclPoints = new LinkedHashMap<LocalVariable, Instruction>();

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        this.varDeclPoints.clear();
        function.accept(this);
        for (Map.Entry<LocalVariable, Instruction> entry : this.varDeclPoints.entrySet()) {
            LocalVariable var = entry.getKey();
            Instruction declPoint = entry.getValue();
            if (this.isDeclaration(declPoint, var)) continue;
            ctx.pushStep("Declare " + var.getUniqueName() + " in outer scope");
            LocalReference newDecl = new LocalReference(var);
            declPoint.insertBefore(newDecl);
            ctx.popStep();
        }
        function.accept(new MergeAliasedDeclarations(), ctx);
    }

    private boolean isDeclaration(Instruction declPoint, LocalVariable var) {
        return LoadStoreMatching.matchLocalRef(declPoint, var) != null || LoadStoreMatching.matchStoreLocal(declPoint, var) != null;
    }

    private boolean replaceVariable(LocalVariable var, LocalVariable replacement, MethodTransformContext ctx) {
        if (!var.getType().equals(replacement.getType()) || var.getIndex() != replacement.getIndex()) {
            return false;
        }
        ctx.pushStep("Merge variable " + var.getUniqueName() + " into " + replacement.getUniqueName());
        List.copyOf(var.getReferences()).forEach(r -> this.replace((LocalReference)r, replacement));
        ctx.popStep();
        return true;
    }

    private void replace(LocalReference r, LocalVariable replacement) {
        if (r.isWrittenTo() || r.isReadFrom()) {
            r.replaceWith(new LocalReference(replacement));
        } else {
            r.remove();
        }
    }

    public static Instruction unifyUsages(Instruction decl, Instruction usage) {
        Instruction commonParent = VariableDeclarations.findCommonParent(decl, usage);
        if (VariableDeclarations.isDeclInInitializerSlot(decl, commonParent)) {
            return decl;
        }
        if (commonParent instanceof Block) {
            return VariableDeclarations.findAncestorChild(decl, commonParent);
        }
        return VariableDeclarations.selectDeclarableParent(commonParent);
    }

    private static boolean isDeclInInitializerSlot(Instruction decl, Instruction commonParent) {
        if (commonParent instanceof ForLoop || commonParent instanceof TryWithResources || commonParent instanceof ForEachLoop || commonParent instanceof TryCatch.TryCatchHandler) {
            return commonParent.getFirstChild() == decl;
        }
        return false;
    }

    public static Instruction selectDeclarableParent(Instruction insn) {
        Block block;
        Instruction instruction;
        while (!((instruction = insn.getParent()) instanceof Block) || (block = (Block)instruction).getFirstChildOrNull() instanceof SwitchTable) {
            if (!((insn = insn.getParent()) instanceof MethodDecl)) continue;
            MethodDecl mDecl = (MethodDecl)insn;
            return mDecl.getBody().getEntryPoint().getFirstChild();
        }
        return insn;
    }

    private static Instruction findAncestorChild(Instruction insn, Instruction ancestor) {
        while (insn.getParent() != ancestor) {
            insn = insn.getParent();
        }
        return insn;
    }

    private static Instruction findCommonParent(Instruction decl, Instruction use2) {
        Instruction parent = decl;
        while (!use2.isDescendantOf(parent = parent.getParent())) {
        }
        return parent;
    }

    @Override
    public None visitLocalReference(LocalReference localRef, None ctx) {
        LocalVariable var = localRef.variable;
        if (var.getKind() == LocalVariable.VariableKind.PARAMETER) {
            return NONE;
        }
        Instruction scope = localRef.getParent() instanceof Store ? localRef.getParent() : localRef;
        Instruction decl = this.varDeclPoints.get(var);
        if (decl == null) {
            assert (localRef.isWrittenTo());
            this.varDeclPoints.put(var, scope);
        } else {
            this.varDeclPoints.put(var, VariableDeclarations.unifyUsages(decl, scope));
        }
        return NONE;
    }

    private class MergeAliasedDeclarations
    extends SimpleInsnVisitor<MethodTransformContext> {
        private final ScopeVisitor<None, MethodTransformContext> scopeVisitor = new ScopeVisitor<None, MethodTransformContext>(this);

        private MergeAliasedDeclarations() {
        }

        @Override
        public None visitDefault(Instruction insn, MethodTransformContext ctx) {
            return MergeAliasedDeclarations.visitChildren(this.scopeVisitor::visit, insn, ctx);
        }

        @Override
        public None visitSwitchSection(SwitchTable.SwitchSection switchSection, MethodTransformContext ctx) {
            super.visitSwitchSection(switchSection, ctx);
            switchSection.explicitBlock = this.scopeVisitor.currentScopeHasDeclarations();
            return NONE;
        }

        @Override
        public None visitLocalReference(LocalReference local, MethodTransformContext ctx) {
            LocalVariable declared = this.scopeVisitor.getVariableInScope(local.variable.getName());
            if (declared != null && declared != local.variable) {
                VariableDeclarations.this.replaceVariable(local.variable, declared, ctx);
            }
            return NONE;
        }
    }
}

